/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.kotlin.internal;

import com.influxdb.LogLevel;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.domain.HealthCheck;
import com.influxdb.client.internal.AbstractInfluxDBClient;
import com.influxdb.client.kotlin.InfluxDBClientKotlin;
import com.influxdb.client.kotlin.QueryKotlinApi;
import com.influxdb.client.kotlin.WriteKotlinApi;
import com.influxdb.client.kotlin.internal.QueryKotlinApiImpl;
import com.influxdb.client.kotlin.internal.WriteKotlinApiImpl;
import com.influxdb.client.service.QueryService;
import com.influxdb.client.service.WriteService;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\b\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/influxdb/client/kotlin/internal/InfluxDBClientKotlinImpl;", "Lcom/influxdb/client/internal/AbstractInfluxDBClient;", "Lcom/influxdb/client/kotlin/InfluxDBClientKotlin;", "options", "Lcom/influxdb/client/InfluxDBClientOptions;", "(Lcom/influxdb/client/InfluxDBClientOptions;)V", "disableGzip", "enableGzip", "getLogLevel", "Lcom/influxdb/LogLevel;", "getQueryKotlinApi", "Lcom/influxdb/client/kotlin/QueryKotlinApi;", "getWriteKotlinApi", "Lcom/influxdb/client/kotlin/WriteKotlinApi;", "health", "Lcom/influxdb/client/domain/HealthCheck;", "isGzipEnabled", "", "ping", "setLogLevel", "logLevel", "version", "", "influxdb-client-kotlin"})
public final class InfluxDBClientKotlinImpl
extends AbstractInfluxDBClient
implements InfluxDBClientKotlin {
    public InfluxDBClientKotlinImpl(@NotNull InfluxDBClientOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        super(options, "kotlin");
    }

    @Override
    @NotNull
    public QueryKotlinApi getQueryKotlinApi() {
        Object object = this.retrofit.create(QueryService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        QueryService queryService = (QueryService)object;
        InfluxDBClientOptions influxDBClientOptions = this.options;
        Intrinsics.checkNotNullExpressionValue((Object)influxDBClientOptions, (String)"options");
        return new QueryKotlinApiImpl(queryService, influxDBClientOptions);
    }

    @Override
    @NotNull
    public WriteKotlinApi getWriteKotlinApi() {
        Object object = this.retrofit.create(WriteService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        WriteService writeService = (WriteService)object;
        InfluxDBClientOptions influxDBClientOptions = this.options;
        Intrinsics.checkNotNullExpressionValue((Object)influxDBClientOptions, (String)"options");
        return new WriteKotlinApiImpl(writeService, influxDBClientOptions);
    }

    @Override
    @Deprecated(message="This method is obsolete. Use `ping()` or `version()`", replaceWith=@ReplaceWith(expression="ping()", imports={}))
    @NotNull
    public HealthCheck health() {
        HealthCheck healthCheck = this.health(this.healthService.getHealth(null));
        Intrinsics.checkNotNullExpressionValue((Object)healthCheck, (String)"health(...)");
        return healthCheck;
    }

    @Override
    public boolean ping() {
        Boolean bl = this.ping(this.pingService.getPing());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ping(...)");
        return bl;
    }

    @Override
    @NotNull
    public String version() {
        String string = this.version(this.pingService.getPing());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"version(...)");
        return string;
    }

    @Override
    @NotNull
    public LogLevel getLogLevel() {
        LogLevel logLevel = this.getLogLevel(this.loggingInterceptor);
        Intrinsics.checkNotNullExpressionValue((Object)logLevel, (String)"getLogLevel(...)");
        return logLevel;
    }

    @Override
    @NotNull
    public InfluxDBClientKotlin setLogLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        this.setLogLevel(this.loggingInterceptor, logLevel);
        return this;
    }

    @Override
    @NotNull
    public InfluxDBClientKotlin enableGzip() {
        this.gzipInterceptor.enableGzip();
        return this;
    }

    @Override
    @NotNull
    public InfluxDBClientKotlin disableGzip() {
        this.gzipInterceptor.disableGzip();
        return this;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.gzipInterceptor.isEnabledGzip();
    }
}

