/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.reactive;

import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.reactive.InfluxDBClientReactive;
import com.influxdb.client.reactive.internal.InfluxDBClientReactiveImpl;
import com.influxdb.utils.Arguments;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InfluxDBClientReactiveFactory {
    private InfluxDBClientReactiveFactory() {
    }

    @Nonnull
    public static InfluxDBClientReactive create() {
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().loadProperties().build();
        return InfluxDBClientReactiveFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClientReactive create(@Nonnull String connectionString) {
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().url(connectionString).build();
        return InfluxDBClientReactiveFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClientReactive create(@Nonnull String url, @Nonnull String username, @Nonnull char[] password) {
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().url(url).authenticate(username, password).build();
        return InfluxDBClientReactiveFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClientReactive create(@Nonnull String url, @Nonnull char[] token) {
        return InfluxDBClientReactiveFactory.create(url, token, null);
    }

    @Nonnull
    public static InfluxDBClientReactive create(@Nonnull String url, @Nonnull char[] token, @Nullable String org) {
        return InfluxDBClientReactiveFactory.create(url, token, org, null);
    }

    @Nonnull
    public static InfluxDBClientReactive create(@Nonnull String url, @Nonnull char[] token, @Nullable String org, @Nullable String bucket) {
        InfluxDBClientOptions options = InfluxDBClientOptions.builder().url(url).authenticateToken(token).org(org).bucket(bucket).build();
        return InfluxDBClientReactiveFactory.create(options);
    }

    @Nonnull
    public static InfluxDBClientReactive create(@Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull((Object)options, (String)"InfluxDBClientOptions");
        return new InfluxDBClientReactiveImpl(options);
    }
}

