/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.reactive;

import com.influxdb.client.WriteApi;
import com.influxdb.utils.Arguments;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class WriteOptionsReactive
implements WriteApi.RetryOptions {
    public static final WriteOptionsReactive DEFAULTS = WriteOptionsReactive.builder().build();
    private final int batchSize;
    private final int flushInterval;
    private final int jitterInterval;
    private final int retryInterval;
    private final int maxRetries;
    private final int maxRetryDelay;
    private final int maxRetryTime;
    private final int exponentialBase;
    private final Scheduler computationScheduler;

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public int getJitterInterval() {
        return this.jitterInterval;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public int getMaxRetryTime() {
        return this.maxRetryTime;
    }

    public int getExponentialBase() {
        return this.exponentialBase;
    }

    @Nonnull
    public Scheduler getComputationScheduler() {
        return this.computationScheduler;
    }

    private WriteOptionsReactive(@Nonnull Builder builder) {
        Arguments.checkNotNull((Object)builder, (String)"WriteOptionsReactive.Builder");
        this.batchSize = builder.batchSize;
        this.flushInterval = builder.flushInterval;
        this.jitterInterval = builder.jitterInterval;
        this.retryInterval = builder.retryInterval;
        this.maxRetries = builder.maxRetries;
        this.maxRetryDelay = builder.maxRetryDelay;
        this.maxRetryTime = builder.maxRetryTime;
        this.exponentialBase = builder.exponentialBase;
        this.computationScheduler = builder.computationScheduler;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static class Builder {
        private int batchSize = 1000;
        private int flushInterval = 1000;
        private int jitterInterval = 0;
        private int retryInterval = 5000;
        private int maxRetries = 5;
        private int maxRetryDelay = 125000;
        private int maxRetryTime = 180000;
        private int exponentialBase = 2;
        private Scheduler computationScheduler = Schedulers.computation();

        @Nonnull
        public Builder batchSize(int batchSize) {
            Arguments.checkNotNegativeNumber((Number)batchSize, (String)"batchSize");
            this.batchSize = batchSize;
            return this;
        }

        @Nonnull
        public Builder flushInterval(int flushInterval) {
            Arguments.checkPositiveNumber((Number)flushInterval, (String)"flushInterval");
            this.flushInterval = flushInterval;
            return this;
        }

        @Nonnull
        public Builder jitterInterval(int jitterInterval) {
            Arguments.checkNotNegativeNumber((Number)jitterInterval, (String)"jitterInterval");
            this.jitterInterval = jitterInterval;
            return this;
        }

        @Nonnull
        public Builder retryInterval(int retryInterval) {
            Arguments.checkPositiveNumber((Number)retryInterval, (String)"retryInterval");
            this.retryInterval = retryInterval;
            return this;
        }

        @Nonnull
        public Builder maxRetries(int maxRetries) {
            Arguments.checkNotNegativeNumber((Number)maxRetries, (String)"maxRetries");
            this.maxRetries = maxRetries;
            return this;
        }

        @Nonnull
        public Builder maxRetryDelay(int maxRetryDelay) {
            Arguments.checkPositiveNumber((Number)maxRetryDelay, (String)"maxRetryDelay");
            this.maxRetryDelay = maxRetryDelay;
            return this;
        }

        @Nonnull
        public Builder maxRetryTime(int maxRetryTime) {
            Arguments.checkPositiveNumber((Number)maxRetryTime, (String)"maxRetryTime");
            this.maxRetryTime = maxRetryTime;
            return this;
        }

        @Nonnull
        public Builder exponentialBase(int exponentialBase) {
            Arguments.checkPositiveNumber((Number)exponentialBase, (String)"exponentialBase");
            this.exponentialBase = exponentialBase;
            return this;
        }

        @Nonnull
        public Builder computationScheduler(@Nonnull Scheduler computationScheduler) {
            Arguments.checkNotNull((Object)computationScheduler, (String)"Computation scheduler");
            this.computationScheduler = computationScheduler;
            return this;
        }

        @Nonnull
        public WriteOptionsReactive build() {
            return new WriteOptionsReactive(this);
        }
    }
}

