/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.reactive.internal;

import com.influxdb.LogLevel;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.domain.HealthCheck;
import com.influxdb.client.internal.AbstractInfluxDBClient;
import com.influxdb.client.reactive.InfluxDBClientReactive;
import com.influxdb.client.reactive.QueryReactiveApi;
import com.influxdb.client.reactive.WriteOptionsReactive;
import com.influxdb.client.reactive.WriteReactiveApi;
import com.influxdb.client.reactive.internal.QueryReactiveApiImpl;
import com.influxdb.client.reactive.internal.WriteReactiveApiImpl;
import com.influxdb.client.service.QueryService;
import com.influxdb.client.service.WriteService;
import com.influxdb.utils.Arguments;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;

public class InfluxDBClientReactiveImpl
extends AbstractInfluxDBClient
implements InfluxDBClientReactive {
    public InfluxDBClientReactiveImpl(@Nonnull InfluxDBClientOptions options) {
        super(options, "java", Collections.singletonList(RxJava3CallAdapterFactory.createSynchronous()));
    }

    @Override
    @Nonnull
    public QueryReactiveApi getQueryReactiveApi() {
        return new QueryReactiveApiImpl((QueryService)this.retrofit.create(QueryService.class), this.options);
    }

    @Override
    @Nonnull
    public WriteReactiveApi getWriteReactiveApi() {
        return this.getWriteReactiveApi(WriteOptionsReactive.DEFAULTS);
    }

    @Override
    @Nonnull
    public WriteReactiveApi getWriteReactiveApi(@Nonnull WriteOptionsReactive writeOptions) {
        Arguments.checkNotNull((Object)writeOptions, (String)"WriteOptions");
        return new WriteReactiveApiImpl(writeOptions, (WriteService)this.retrofit.create(WriteService.class), this.options);
    }

    @Override
    @Nonnull
    public Publisher<HealthCheck> health() {
        return Flowable.fromCallable(() -> this.health(this.healthService.getHealth(null)));
    }

    @Override
    @Nonnull
    public LogLevel getLogLevel() {
        return this.getLogLevel(this.loggingInterceptor);
    }

    @Override
    @Nonnull
    public InfluxDBClientReactive setLogLevel(@Nonnull LogLevel logLevel) {
        this.setLogLevel(this.loggingInterceptor, logLevel);
        return this;
    }

    @Override
    @Nonnull
    public InfluxDBClientReactive enableGzip() {
        this.gzipInterceptor.enableGzip();
        return this;
    }

    @Override
    @Nonnull
    public InfluxDBClientReactive disableGzip() {
        this.gzipInterceptor.disableGzip();
        return this;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.gzipInterceptor.isEnabledGzip();
    }
}

