/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.reactive.internal;

import com.influxdb.Cancellable;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.domain.Dialect;
import com.influxdb.client.domain.Query;
import com.influxdb.client.internal.AbstractInfluxDBClient;
import com.influxdb.client.reactive.QueryReactiveApi;
import com.influxdb.client.service.QueryService;
import com.influxdb.internal.AbstractQueryApi;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import com.influxdb.query.internal.FluxCsvParser;
import com.influxdb.utils.Arguments;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import retrofit2.Call;

final class QueryReactiveApiImpl
extends AbstractQueryApi
implements QueryReactiveApi {
    private final QueryService service;
    private final InfluxDBClientOptions options;

    QueryReactiveApiImpl(@Nonnull QueryService service, @Nonnull InfluxDBClientOptions options) {
        Arguments.checkNotNull((Object)service, (String)"InfluxDBReactiveService");
        Arguments.checkNotNull((Object)options, (String)"options");
        this.service = service;
        this.options = options;
    }

    @Override
    @Nonnull
    public Publisher<FluxRecord> query(@Nonnull String query) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.query(query, this.options.getOrg());
    }

    @Override
    @Nonnull
    public Publisher<FluxRecord> query(@Nonnull String query, @Nonnull String org) {
        Arguments.checkNonEmpty((String)query, (String)"Flux query");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return this.query((Publisher<String>)Flowable.just((Object)query), org);
    }

    @Override
    @Nonnull
    public Publisher<FluxRecord> query(@Nonnull Query query, @Nonnull String org) {
        Arguments.checkNotNull((Object)query, (String)"Flux query");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return this.queryQuery((Publisher<Query>)Flowable.just((Object)query), org);
    }

    @Override
    @Nonnull
    public Publisher<FluxRecord> query(@Nonnull Query query) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        Arguments.checkNotNull((Object)query, (String)"Flux query");
        return this.queryQuery((Publisher<Query>)Flowable.just((Object)query), this.options.getOrg());
    }

    @Override
    public <M> Publisher<M> query(@Nonnull String query, @Nonnull Class<M> measurementType) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.query(query, this.options.getOrg(), measurementType);
    }

    @Override
    public <M> Publisher<M> query(@Nonnull String query, @Nonnull String org, @Nonnull Class<M> measurementType) {
        Arguments.checkNonEmpty((String)query, (String)"Flux query");
        Arguments.checkNotNull(measurementType, (String)"Measurement type");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return this.query((Publisher<String>)Flowable.just((Object)query), org, measurementType);
    }

    @Override
    public <M> Publisher<M> query(@Nonnull Query query, @Nonnull String org, @Nonnull Class<M> measurementType) {
        Arguments.checkNotNull((Object)query, (String)"Flux query");
        Arguments.checkNotNull(measurementType, (String)"Measurement type");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return Flowable.fromPublisher(this.queryQuery((Publisher<Query>)Flowable.just((Object)query), org)).map(fluxRecord -> this.resultMapper.toPOJO(fluxRecord, measurementType));
    }

    @Override
    @Nonnull
    public Publisher<FluxRecord> query(@Nonnull Publisher<String> queryStream) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.query(queryStream, this.options.getOrg());
    }

    @Override
    @Nonnull
    public Publisher<FluxRecord> query(@Nonnull Publisher<String> queryStream, @Nonnull String org) {
        return this.queryQuery((Publisher<Query>)Flowable.fromPublisher(queryStream).map(query -> new Query().query(query).dialect(AbstractInfluxDBClient.DEFAULT_DIALECT)), org);
    }

    @Override
    @Nonnull
    public Publisher<FluxRecord> queryQuery(@Nonnull Publisher<Query> queryStream, @Nonnull String org) {
        Arguments.checkNotNull(queryStream, (String)"queryStream");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return Flowable.fromPublisher(queryStream).map(it -> this.service.postQueryResponseBody(null, null, null, org, null, it.dialect(AbstractInfluxDBClient.DEFAULT_DIALECT))).flatMap(queryCall -> {
            Observable observable = Observable.create(subscriber -> {
                FluxCsvParser.FluxResponseConsumer consumer = new FluxCsvParser.FluxResponseConsumer(){

                    public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxTable table) {
                    }

                    public void accept(int index, @Nonnull Cancellable cancellable, @Nonnull FluxRecord record) {
                        if (subscriber.isDisposed()) {
                            cancellable.cancel();
                        } else {
                            subscriber.onNext((Object)record);
                        }
                    }
                };
                this.query((Call)queryCall, consumer, this.onError(subscriber), () -> ((ObservableEmitter)subscriber).onComplete(), false);
            });
            return observable.toFlowable(BackpressureStrategy.BUFFER);
        });
    }

    @Override
    @Nonnull
    public <M> Publisher<M> query(@Nonnull Publisher<String> queryStream, @Nonnull Class<M> measurementType) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.query(queryStream, this.options.getOrg(), measurementType);
    }

    @Override
    @Nonnull
    public <M> Publisher<M> query(@Nonnull Publisher<String> queryStream, @Nonnull String org, @Nonnull Class<M> measurementType) {
        Arguments.checkNotNull(queryStream, (String)"queryStream");
        Arguments.checkNotNull(measurementType, (String)"Measurement type");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return Flowable.fromPublisher(this.query(queryStream, org)).map(fluxRecord -> this.resultMapper.toPOJO(fluxRecord, measurementType));
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull String query) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.queryRaw(query, this.options.getOrg());
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull Query query) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.queryRawQuery((Publisher<Query>)Flowable.just((Object)query), null, this.options.getOrg());
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull String query, @Nonnull String org) {
        Arguments.checkNonEmpty((String)query, (String)"Flux query");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return this.queryRaw((Publisher<String>)Flowable.just((Object)query), org);
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull Publisher<String> queryStream) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.queryRaw(queryStream, this.options.getOrg());
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull Publisher<String> queryStream, @Nonnull String org) {
        Arguments.checkNotNull(queryStream, (String)"queryStream");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return this.queryRaw(queryStream, AbstractInfluxDBClient.DEFAULT_DIALECT, org);
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull String query, @Nullable Dialect dialect) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.queryRaw(query, dialect, this.options.getOrg());
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull String query, @Nullable Dialect dialect, @Nonnull String org) {
        Arguments.checkNonEmpty((String)query, (String)"Flux query");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return this.queryRaw((Publisher<String>)Flowable.just((Object)query), dialect, org);
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull Publisher<String> queryStream, @Nullable Dialect dialect) {
        Arguments.checkNotNull((Object)this.options.getOrg(), (String)"InfluxDBClientOptions.getOrg");
        return this.queryRaw(queryStream, dialect, this.options.getOrg());
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull Query query, @Nullable Dialect dialect, @Nonnull String org) {
        return this.queryRawQuery((Publisher<Query>)Flowable.just((Object)query), dialect, org);
    }

    @Override
    @Nonnull
    public Publisher<String> queryRawQuery(@Nonnull Publisher<Query> queryStream, @Nullable Dialect dialect, @Nonnull String org) {
        Arguments.checkNotNull(queryStream, (String)"queryStream");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return Flowable.fromPublisher(queryStream).map(it -> this.service.postQueryResponseBody(null, null, null, org, null, it.dialect(dialect))).flatMap(queryCall -> {
            Observable observable = Observable.create(subscriber -> {
                BiConsumer<Cancellable, String> consumer = (cancellable, line) -> {
                    if (subscriber.isDisposed()) {
                        cancellable.cancel();
                    } else {
                        subscriber.onNext(line);
                    }
                };
                this.queryRaw((Call)queryCall, consumer, this.onError(subscriber), () -> ((ObservableEmitter)subscriber).onComplete(), false);
            });
            return observable.toFlowable(BackpressureStrategy.BUFFER);
        });
    }

    @Override
    @Nonnull
    public Publisher<String> queryRaw(@Nonnull Publisher<String> queryStream, @Nullable Dialect dialect, @Nonnull String org) {
        Arguments.checkNotNull(queryStream, (String)"queryStream");
        Arguments.checkNonEmpty((String)org, (String)"org");
        return this.queryRawQuery((Publisher<Query>)Flowable.fromPublisher(queryStream).map(q -> new Query().query(q).dialect(dialect)), dialect, org);
    }

    @Nonnull
    private Consumer<Throwable> onError(ObservableEmitter<?> subscriber) {
        return throwable -> {
            if (!subscriber.isDisposed()) {
                subscriber.onError(throwable);
            } else {
                LOG.log(Level.FINEST, "The exception could not be delivered to the consumer because it has already canceled/disposed.", (Throwable)throwable);
            }
        };
    }
}

