/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.spring.influx;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.spring.influx.AbstractInfluxDB2AutoConfiguration;
import com.influxdb.spring.influx.InfluxDB2OkHttpClientBuilderProvider;
import com.influxdb.spring.influx.InfluxDB2Properties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={InfluxDBClient.class})
@EnableConfigurationProperties(value={InfluxDB2Properties.class})
public class InfluxDB2AutoConfiguration
extends AbstractInfluxDB2AutoConfiguration {
    public InfluxDB2AutoConfiguration(InfluxDB2Properties properties, ObjectProvider<InfluxDB2OkHttpClientBuilderProvider> builderProvider) {
        super(properties, (InfluxDB2OkHttpClientBuilderProvider)builderProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnProperty(value={"influx.url"})
    @ConditionalOnMissingBean(value={InfluxDBClient.class})
    public InfluxDBClient influxDBClient() {
        InfluxDBClientOptions.Builder influxBuilder = this.makeBuilder();
        return InfluxDBClientFactory.create((InfluxDBClientOptions)influxBuilder.build()).setLogLevel(this.properties.getLogLevel());
    }
}

