/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.spring.influx;

import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.client.reactive.InfluxDBClientReactive;
import com.influxdb.client.reactive.InfluxDBClientReactiveFactory;
import com.influxdb.spring.influx.AbstractInfluxDB2AutoConfiguration;
import com.influxdb.spring.influx.InfluxDB2OkHttpClientBuilderProvider;
import com.influxdb.spring.influx.InfluxDB2Properties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"com.influxdb.client.reactive.InfluxDBClientReactive"})
@EnableConfigurationProperties(value={InfluxDB2Properties.class})
public class InfluxDB2AutoConfigurationReactive
extends AbstractInfluxDB2AutoConfiguration {
    public InfluxDB2AutoConfigurationReactive(InfluxDB2Properties properties, ObjectProvider<InfluxDB2OkHttpClientBuilderProvider> builderProvider) {
        super(properties, (InfluxDB2OkHttpClientBuilderProvider)builderProvider.getIfAvailable());
    }

    @Bean
    @ConditionalOnProperty(value={"influx.url"})
    @ConditionalOnMissingBean(value={InfluxDBClientReactive.class})
    public InfluxDBClientReactive influxDBClientReactive() {
        InfluxDBClientOptions.Builder influxBuilder = this.makeBuilder();
        return InfluxDBClientReactiveFactory.create((InfluxDBClientOptions)influxBuilder.build()).setLogLevel(this.properties.getLogLevel());
    }
}

