/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.spring.health;

import com.influxdb.client.InfluxDBClient;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;

public class InfluxDB2HealthIndicator
extends AbstractHealthIndicator {
    private final InfluxDBClient influxDBClient;

    public InfluxDB2HealthIndicator(InfluxDBClient influxDBClient) {
        super("InfluxDBClient 2 health check failed");
        Assert.notNull((Object)influxDBClient, (String)"InfluxDBClient must not be null");
        this.influxDBClient = influxDBClient;
    }

    protected void doHealthCheck(Health.Builder builder) {
        boolean success = this.influxDBClient.ping();
        if (success) {
            builder.up();
        } else {
            builder.down();
        }
    }
}

