/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.spring.influx;

import com.influxdb.client.InfluxDBClientOptions;
import com.influxdb.spring.influx.InfluxDB2OkHttpClientBuilderProvider;
import com.influxdb.spring.influx.InfluxDB2Properties;
import java.util.Collections;
import javax.annotation.Nonnull;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.springframework.util.StringUtils;

abstract class AbstractInfluxDB2AutoConfiguration {
    protected final InfluxDB2Properties properties;
    protected final InfluxDB2OkHttpClientBuilderProvider builderProvider;

    protected AbstractInfluxDB2AutoConfiguration(InfluxDB2Properties properties, InfluxDB2OkHttpClientBuilderProvider builderProvider) {
        this.properties = properties;
        this.builderProvider = builderProvider;
    }

    @Nonnull
    protected InfluxDBClientOptions.Builder makeBuilder() {
        OkHttpClient.Builder okHttpBuilder = this.builderProvider == null ? new OkHttpClient.Builder().protocols(Collections.singletonList(Protocol.HTTP_1_1)).readTimeout(this.properties.getReadTimeout()).writeTimeout(this.properties.getWriteTimeout()).connectTimeout(this.properties.getConnectTimeout()) : (OkHttpClient.Builder)this.builderProvider.get();
        InfluxDBClientOptions.Builder influxBuilder = InfluxDBClientOptions.builder().url(this.properties.getUrl()).bucket(this.properties.getBucket()).org(this.properties.getOrg()).okHttpClient(okHttpBuilder);
        if (StringUtils.hasLength((String)this.properties.getToken())) {
            influxBuilder.authenticateToken(this.properties.getToken().toCharArray());
        } else if (StringUtils.hasLength((String)this.properties.getUsername()) && StringUtils.hasLength((String)this.properties.getPassword())) {
            influxBuilder.authenticate(this.properties.getUsername(), this.properties.getPassword().toCharArray());
        }
        return influxBuilder;
    }
}

