/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.influxdb.v3.client.InfluxDBApiException;
import com.influxdb.v3.client.InfluxDBApiHttpException;
import com.influxdb.v3.client.config.ClientConfig;
import com.influxdb.v3.client.internal.Arguments;
import com.influxdb.v3.client.internal.Identity;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RestClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RestClient.class);
    private static final TrustManager[] TRUST_ALL_CERTS = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    final String baseUrl;
    final String userAgent;
    final HttpClient client;
    private final ClientConfig config;
    private final Map<String, String> defaultHeaders;
    private final ObjectMapper objectMapper = new ObjectMapper();

    RestClient(@Nonnull ClientConfig config) {
        Arguments.checkNotNull(config, "config");
        this.config = config;
        this.userAgent = Identity.getUserAgent();
        String host = config.getHost();
        this.baseUrl = host.endsWith("/") ? host : String.format("%s/", host);
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(config.getTimeout()).followRedirects(config.getAllowHttpRedirects() != false ? HttpClient.Redirect.NORMAL : HttpClient.Redirect.NEVER);
        Map<String, String> map = this.defaultHeaders = config.getHeaders() != null ? Map.copyOf(config.getHeaders()) : null;
        if (config.getProxyUrl() != null) {
            URI proxyUri = URI.create(config.getProxyUrl());
            ProxySelector proxy = ProxySelector.of(new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort()));
            builder.proxy(proxy);
            if (config.getAuthenticator() != null) {
                builder.authenticator(config.getAuthenticator());
            }
        } else if (config.getProxy() != null) {
            builder.proxy(config.getProxy());
            if (config.getAuthenticator() != null) {
                builder.authenticator(config.getAuthenticator());
            }
        }
        if (this.baseUrl.startsWith("https")) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                if (config.getDisableServerCertificateValidation().booleanValue()) {
                    sslContext.init(null, TRUST_ALL_CERTS, new SecureRandom());
                } else if (config.sslRootsFilePath() != null) {
                    X509TrustManager x509TrustManager = this.getX509TrustManagerFromFile(config.sslRootsFilePath());
                    sslContext.init(null, new X509TrustManager[]{x509TrustManager}, new SecureRandom());
                } else {
                    sslContext.init(null, null, new SecureRandom());
                }
                builder.sslContext(sslContext);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.client = builder.build();
    }

    public String getServerVersion() {
        String influxdbVersion;
        HttpResponse<String> response = this.request("ping", HttpMethod.GET, null, null, null);
        try {
            influxdbVersion = response.headers().firstValue("X-Influxdb-Version").orElse(null);
            if (influxdbVersion == null) {
                JsonNode jsonNode = this.objectMapper.readTree(response.body());
                influxdbVersion = Optional.ofNullable(jsonNode.get("version")).map(JsonNode::asText).orElse(null);
            }
        }
        catch (JsonProcessingException e) {
            return null;
        }
        return influxdbVersion;
    }

    HttpResponse<String> request(@Nonnull String path, @Nonnull HttpMethod method, @Nullable byte[] data, @Nullable Map<String, String> queryParams, @Nullable Map<String, String> headers) {
        HttpResponse<String> response;
        QueryStringEncoder uriEncoder = new QueryStringEncoder(String.format("%s%s", this.baseUrl, path));
        if (queryParams != null) {
            queryParams.forEach((name, value) -> {
                if (value != null && !value.isEmpty()) {
                    uriEncoder.addParam(name, value);
                }
            });
        }
        HttpRequest.Builder request = HttpRequest.newBuilder();
        try {
            request.uri(uriEncoder.toUri());
        }
        catch (URISyntaxException e) {
            throw new InfluxDBApiException(e);
        }
        request.method(method.name(), data == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofByteArray(data));
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                request.header(entry.getKey(), entry.getValue());
            }
        }
        if (this.defaultHeaders != null) {
            for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
                if (headers != null && headers.containsKey(entry.getKey())) continue;
                request.header(entry.getKey(), entry.getValue());
            }
        }
        request.header("User-Agent", this.userAgent);
        if (this.config.getToken() != null && this.config.getToken().length > 0) {
            String authScheme = this.config.getAuthScheme();
            if (authScheme == null) {
                authScheme = "Token";
            }
            request.header("Authorization", String.format("%s %s", authScheme, new String(this.config.getToken())));
        }
        try {
            response = this.client.send(request.build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new InfluxDBApiException(e);
        }
        int statusCode = response.statusCode();
        if (statusCode < 200 || statusCode >= 300) {
            String reason = "";
            String body = response.body();
            if (!body.isEmpty()) {
                try {
                    JsonNode root = this.objectMapper.readTree(body);
                    List<String> possibilities = List.of("message", "error_message", "error");
                    for (String field : possibilities) {
                        JsonNode node = root.findValue(field);
                        if (node == null) continue;
                        reason = node.asText();
                        break;
                    }
                }
                catch (JsonProcessingException e) {
                    LOG.debug("Can't parse msg from response {}", response);
                }
            }
            if (reason.isEmpty()) {
                reason = Stream.of("X-Platform-Error-Code", "X-Influx-Error", "X-InfluxDb-Error").map(name -> response.headers().firstValue((String)name).orElse(null)).filter(message -> message != null && !message.isEmpty()).findFirst().orElse("");
            }
            if (reason.isEmpty()) {
                reason = body;
            }
            if (reason.isEmpty()) {
                reason = HttpResponseStatus.valueOf((int)statusCode).reasonPhrase();
            }
            String message2 = String.format("HTTP status code: %d; Message: %s", statusCode, reason);
            throw new InfluxDBApiHttpException(message2, response.headers(), response.statusCode());
        }
        return response;
    }

    private X509TrustManager getX509TrustManagerFromFile(@Nonnull String filePath) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            FileInputStream fis = new FileInputStream(filePath);
            ArrayList<? extends Certificate> certificates = new ArrayList<Certificate>(CertificateFactory.getInstance("X.509").generateCertificates(fis));
            for (int i = 0; i < certificates.size(); ++i) {
                Certificate cert = (Certificate)certificates.get(i);
                trustStore.setCertificateEntry("alias" + i, cert);
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            X509TrustManager x509TrustManager = null;
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                x509TrustManager = (X509TrustManager)trustManager;
            }
            return x509TrustManager;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
    }
}

