/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.api;

import com.google.gson.reflect.TypeToken;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.ApiResponse;
import com.infobip.Configuration;
import com.infobip.Pair;
import com.infobip.model.WhatsAppTemplateApiResponse;
import com.infobip.model.WhatsAppTemplatePublicApiRequest;
import com.infobip.model.WhatsAppTemplatesApiResponse;
import com.infobip.model.WhatsAppUrlDeletionRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManageWhatsAppApi {
  private ApiClient localVarApiClient;

  public ManageWhatsAppApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ManageWhatsAppApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  /**
   * Build call for createWhatsAppTemplate.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param whatsAppTemplatePublicApiRequest (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call createWhatsAppTemplateCall(
      String sender,
      WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest,
      final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = whatsAppTemplatePublicApiRequest;

    // create path and map variables
    String localVarPath =
        "/whatsapp/1/senders/{sender}/templates"
            .replaceAll(
                "\\{" + "sender" + "\\}", localVarApiClient.escapeString(sender.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call createWhatsAppTemplateValidateBeforeCall(
      String sender,
      WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest,
      final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'sender' is set
    if (sender == null) {
      throw new ApiException(
          "Missing the required parameter 'sender' when calling createWhatsAppTemplate(Async)");
    }

    // verify the required parameter 'whatsAppTemplatePublicApiRequest' is set
    if (whatsAppTemplatePublicApiRequest == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppTemplatePublicApiRequest' when calling"
              + " createWhatsAppTemplate(Async)");
    }

    okhttp3.Call localVarCall =
        createWhatsAppTemplateCall(sender, whatsAppTemplatePublicApiRequest, _callback);
    return localVarCall;
  }

  /**
   * Create WhatsApp Template. Create WhatsApp template. Created template will be submitted for
   * WhatsApp&#39;s review and approval. Once approved, template can be sent to end-users. Refer to
   * [template
   * guidelines](https://www.infobip.com/docs/whatsapp/message-types#guidelines-amp-best-practices)
   * for additional info.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param whatsAppTemplatePublicApiRequest (required)
   * @return WhatsAppTemplateApiResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppTemplateApiResponse createWhatsAppTemplate(
      String sender, WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest)
      throws ApiException {
    ApiResponse<WhatsAppTemplateApiResponse> localVarResp =
        createWhatsAppTemplateWithHttpInfo(sender, whatsAppTemplatePublicApiRequest);
    return localVarResp.getData();
  }

  /**
   * Create WhatsApp Template. Create WhatsApp template. Created template will be submitted for
   * WhatsApp&#39;s review and approval. Once approved, template can be sent to end-users. Refer to
   * [template
   * guidelines](https://www.infobip.com/docs/whatsapp/message-types#guidelines-amp-best-practices)
   * for additional info.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param whatsAppTemplatePublicApiRequest (required)
   * @return ApiResponse&lt;WhatsAppTemplateApiResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppTemplateApiResponse> createWhatsAppTemplateWithHttpInfo(
      String sender, WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest)
      throws ApiException {
    okhttp3.Call localVarCall =
        createWhatsAppTemplateValidateBeforeCall(sender, whatsAppTemplatePublicApiRequest, null);
    Type localVarReturnType = new TypeToken<WhatsAppTemplateApiResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Create WhatsApp Template (asynchronously). Create WhatsApp template. Created template will be
   * submitted for WhatsApp&#39;s review and approval. Once approved, template can be sent to
   * end-users. Refer to [template
   * guidelines](https://www.infobip.com/docs/whatsapp/message-types#guidelines-amp-best-practices)
   * for additional info.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param whatsAppTemplatePublicApiRequest (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call createWhatsAppTemplateAsync(
      String sender,
      WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest,
      final ApiCallback<WhatsAppTemplateApiResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        createWhatsAppTemplateValidateBeforeCall(
            sender, whatsAppTemplatePublicApiRequest, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppTemplateApiResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for deleteWhatsAppMedia.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param whatsAppUrlDeletionRequest (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call deleteWhatsAppMediaCall(
      String sender,
      WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest,
      final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = whatsAppUrlDeletionRequest;

    // create path and map variables
    String localVarPath =
        "/whatsapp/1/senders/{sender}/media"
            .replaceAll(
                "\\{" + "sender" + "\\}", localVarApiClient.escapeString(sender.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"*/*"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call deleteWhatsAppMediaValidateBeforeCall(
      String sender,
      WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest,
      final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'sender' is set
    if (sender == null) {
      throw new ApiException(
          "Missing the required parameter 'sender' when calling deleteWhatsAppMedia(Async)");
    }

    // verify the required parameter 'whatsAppUrlDeletionRequest' is set
    if (whatsAppUrlDeletionRequest == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppUrlDeletionRequest' when calling"
              + " deleteWhatsAppMedia(Async)");
    }

    okhttp3.Call localVarCall =
        deleteWhatsAppMediaCall(sender, whatsAppUrlDeletionRequest, _callback);
    return localVarCall;
  }

  /**
   * Delete media. Delete WhatsApp media. May be outbound or inbound media.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param whatsAppUrlDeletionRequest (required)
   * @return String
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public String deleteWhatsAppMedia(
      String sender, WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest) throws ApiException {
    ApiResponse<String> localVarResp =
        deleteWhatsAppMediaWithHttpInfo(sender, whatsAppUrlDeletionRequest);
    return localVarResp.getData();
  }

  /**
   * Delete media. Delete WhatsApp media. May be outbound or inbound media.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param whatsAppUrlDeletionRequest (required)
   * @return ApiResponse&lt;String&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<String> deleteWhatsAppMediaWithHttpInfo(
      String sender, WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest) throws ApiException {
    okhttp3.Call localVarCall =
        deleteWhatsAppMediaValidateBeforeCall(sender, whatsAppUrlDeletionRequest, null);
    Type localVarReturnType = new TypeToken<String>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Delete media (asynchronously). Delete WhatsApp media. May be outbound or inbound media.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param whatsAppUrlDeletionRequest (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call deleteWhatsAppMediaAsync(
      String sender,
      WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest,
      final ApiCallback<String> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        deleteWhatsAppMediaValidateBeforeCall(sender, whatsAppUrlDeletionRequest, _callback);
    Type localVarReturnType = new TypeToken<String>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getWhatsAppTemplates.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call getWhatsAppTemplatesCall(String sender, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/whatsapp/1/senders/{sender}/templates"
            .replaceAll(
                "\\{" + "sender" + "\\}", localVarApiClient.escapeString(sender.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getWhatsAppTemplatesValidateBeforeCall(
      String sender, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'sender' is set
    if (sender == null) {
      throw new ApiException(
          "Missing the required parameter 'sender' when calling getWhatsAppTemplates(Async)");
    }

    okhttp3.Call localVarCall = getWhatsAppTemplatesCall(sender, _callback);
    return localVarCall;
  }

  /**
   * Get WhatsApp Templates. Get all the templates and their statuses for a given sender.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @return WhatsAppTemplatesApiResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppTemplatesApiResponse getWhatsAppTemplates(String sender) throws ApiException {
    ApiResponse<WhatsAppTemplatesApiResponse> localVarResp =
        getWhatsAppTemplatesWithHttpInfo(sender);
    return localVarResp.getData();
  }

  /**
   * Get WhatsApp Templates. Get all the templates and their statuses for a given sender.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @return ApiResponse&lt;WhatsAppTemplatesApiResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppTemplatesApiResponse> getWhatsAppTemplatesWithHttpInfo(String sender)
      throws ApiException {
    okhttp3.Call localVarCall = getWhatsAppTemplatesValidateBeforeCall(sender, null);
    Type localVarReturnType = new TypeToken<WhatsAppTemplatesApiResponse>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get WhatsApp Templates (asynchronously). Get all the templates and their statuses for a given
   * sender.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call getWhatsAppTemplatesAsync(
      String sender, final ApiCallback<WhatsAppTemplatesApiResponse> _callback)
      throws ApiException {

    okhttp3.Call localVarCall = getWhatsAppTemplatesValidateBeforeCall(sender, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppTemplatesApiResponse>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
