/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.api;

import com.google.gson.reflect.TypeToken;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.ApiResponse;
import com.infobip.Configuration;
import com.infobip.Pair;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReceiveWhatsAppApi {
  private ApiClient localVarApiClient;

  public ReceiveWhatsAppApi() {
    this(Configuration.getDefaultApiClient());
  }

  public ReceiveWhatsAppApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  /**
   * Build call for downloadWhatsAppInboundMedia.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param mediaId ID of the media. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call downloadWhatsAppInboundMediaCall(
      String sender, String mediaId, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/whatsapp/1/senders/{sender}/media/{mediaId}"
            .replaceAll("\\{" + "sender" + "\\}", localVarApiClient.escapeString(sender.toString()))
            .replaceAll(
                "\\{" + "mediaId" + "\\}", localVarApiClient.escapeString(mediaId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"*/*"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call downloadWhatsAppInboundMediaValidateBeforeCall(
      String sender, String mediaId, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'sender' is set
    if (sender == null) {
      throw new ApiException(
          "Missing the required parameter 'sender' when calling"
              + " downloadWhatsAppInboundMedia(Async)");
    }

    // verify the required parameter 'mediaId' is set
    if (mediaId == null) {
      throw new ApiException(
          "Missing the required parameter 'mediaId' when calling"
              + " downloadWhatsAppInboundMedia(Async)");
    }

    okhttp3.Call localVarCall = downloadWhatsAppInboundMediaCall(sender, mediaId, _callback);
    return localVarCall;
  }

  /**
   * Download inbound media. Download WhatsApp media sent by end-users.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param mediaId ID of the media. (required)
   * @return File
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public File downloadWhatsAppInboundMedia(String sender, String mediaId) throws ApiException {
    ApiResponse<File> localVarResp = downloadWhatsAppInboundMediaWithHttpInfo(sender, mediaId);
    return localVarResp.getData();
  }

  /**
   * Download inbound media. Download WhatsApp media sent by end-users.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param mediaId ID of the media. (required)
   * @return ApiResponse&lt;File&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<File> downloadWhatsAppInboundMediaWithHttpInfo(String sender, String mediaId)
      throws ApiException {
    okhttp3.Call localVarCall =
        downloadWhatsAppInboundMediaValidateBeforeCall(sender, mediaId, null);
    Type localVarReturnType = new TypeToken<File>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Download inbound media (asynchronously). Download WhatsApp media sent by end-users.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param mediaId ID of the media. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call downloadWhatsAppInboundMediaAsync(
      String sender, String mediaId, final ApiCallback<File> _callback) throws ApiException {

    okhttp3.Call localVarCall =
        downloadWhatsAppInboundMediaValidateBeforeCall(sender, mediaId, _callback);
    Type localVarReturnType = new TypeToken<File>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for getWhatsAppMediaMetadata.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param mediaId ID of the media. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call getWhatsAppMediaMetadataCall(
      String sender, String mediaId, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/whatsapp/1/senders/{sender}/media/{mediaId}"
            .replaceAll("\\{" + "sender" + "\\}", localVarApiClient.escapeString(sender.toString()))
            .replaceAll(
                "\\{" + "mediaId" + "\\}", localVarApiClient.escapeString(mediaId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"*/*"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "HEAD",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call getWhatsAppMediaMetadataValidateBeforeCall(
      String sender, String mediaId, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'sender' is set
    if (sender == null) {
      throw new ApiException(
          "Missing the required parameter 'sender' when calling getWhatsAppMediaMetadata(Async)");
    }

    // verify the required parameter 'mediaId' is set
    if (mediaId == null) {
      throw new ApiException(
          "Missing the required parameter 'mediaId' when calling getWhatsAppMediaMetadata(Async)");
    }

    okhttp3.Call localVarCall = getWhatsAppMediaMetadataCall(sender, mediaId, _callback);
    return localVarCall;
  }

  /**
   * Get media metadata. Get metadata of WhatsApp media sent by end-users.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param mediaId ID of the media. (required)
   * @return String
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public String getWhatsAppMediaMetadata(String sender, String mediaId) throws ApiException {
    ApiResponse<String> localVarResp = getWhatsAppMediaMetadataWithHttpInfo(sender, mediaId);
    return localVarResp.getData();
  }

  /**
   * Get media metadata. Get metadata of WhatsApp media sent by end-users.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param mediaId ID of the media. (required)
   * @return ApiResponse&lt;String&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<String> getWhatsAppMediaMetadataWithHttpInfo(String sender, String mediaId)
      throws ApiException {
    okhttp3.Call localVarCall = getWhatsAppMediaMetadataValidateBeforeCall(sender, mediaId, null);
    Type localVarReturnType = new TypeToken<String>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Get media metadata (asynchronously). Get metadata of WhatsApp media sent by end-users.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param mediaId ID of the media. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call getWhatsAppMediaMetadataAsync(
      String sender, String mediaId, final ApiCallback<String> _callback) throws ApiException {

    okhttp3.Call localVarCall =
        getWhatsAppMediaMetadataValidateBeforeCall(sender, mediaId, _callback);
    Type localVarReturnType = new TypeToken<String>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for markWhatsAppMessageAsRead.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param messageId ID of the message to be marked as read. (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call markWhatsAppMessageAsReadCall(
      String sender, String messageId, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath =
        "/whatsapp/1/senders/{sender}/message/{messageId}/read"
            .replaceAll("\\{" + "sender" + "\\}", localVarApiClient.escapeString(sender.toString()))
            .replaceAll(
                "\\{" + "messageId" + "\\}", localVarApiClient.escapeString(messageId.toString()));

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {};

    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call markWhatsAppMessageAsReadValidateBeforeCall(
      String sender, String messageId, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'sender' is set
    if (sender == null) {
      throw new ApiException(
          "Missing the required parameter 'sender' when calling markWhatsAppMessageAsRead(Async)");
    }

    // verify the required parameter 'messageId' is set
    if (messageId == null) {
      throw new ApiException(
          "Missing the required parameter 'messageId' when calling"
              + " markWhatsAppMessageAsRead(Async)");
    }

    okhttp3.Call localVarCall = markWhatsAppMessageAsReadCall(sender, messageId, _callback);
    return localVarCall;
  }

  /**
   * Mark as read. Mark WhatsApp messages sent by end-users as read.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param messageId ID of the message to be marked as read. (required)
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public void markWhatsAppMessageAsRead(String sender, String messageId) throws ApiException {
    markWhatsAppMessageAsReadWithHttpInfo(sender, messageId);
  }

  /**
   * Mark as read. Mark WhatsApp messages sent by end-users as read.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param messageId ID of the message to be marked as read. (required)
   * @return ApiResponse&lt;Void&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<Void> markWhatsAppMessageAsReadWithHttpInfo(String sender, String messageId)
      throws ApiException {
    okhttp3.Call localVarCall =
        markWhatsAppMessageAsReadValidateBeforeCall(sender, messageId, null);
    return localVarApiClient.execute(localVarCall);
  }

  /**
   * Mark as read (asynchronously). Mark WhatsApp messages sent by end-users as read.
   *
   * @param sender Registered WhatsApp sender number. Must be in international format. (required)
   * @param messageId ID of the message to be marked as read. (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call markWhatsAppMessageAsReadAsync(
      String sender, String messageId, final ApiCallback<Void> _callback) throws ApiException {

    okhttp3.Call localVarCall =
        markWhatsAppMessageAsReadValidateBeforeCall(sender, messageId, _callback);
    localVarApiClient.executeAsync(localVarCall, _callback);
    return localVarCall;
  }
}
