/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.api;

import com.google.gson.reflect.TypeToken;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.ApiResponse;
import com.infobip.Configuration;
import com.infobip.Pair;
import com.infobip.model.WhatsAppAudioMessage;
import com.infobip.model.WhatsAppBulkMessage;
import com.infobip.model.WhatsAppBulkMessageInfo;
import com.infobip.model.WhatsAppContactsMessage;
import com.infobip.model.WhatsAppDocumentMessage;
import com.infobip.model.WhatsAppImageMessage;
import com.infobip.model.WhatsAppInteractiveButtonsMessage;
import com.infobip.model.WhatsAppInteractiveListMessage;
import com.infobip.model.WhatsAppLocationMessage;
import com.infobip.model.WhatsAppSingleMessageInfo;
import com.infobip.model.WhatsAppStickerMessage;
import com.infobip.model.WhatsAppTextMessage;
import com.infobip.model.WhatsAppVideoMessage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SendWhatsAppApi {
  private ApiClient localVarApiClient;

  public SendWhatsAppApi() {
    this(Configuration.getDefaultApiClient());
  }

  public SendWhatsAppApi(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return localVarApiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.localVarApiClient = apiClient;
  }

  /**
   * Build call for sendWhatsAppAudioMessage.
   *
   * @param whatsAppAudioMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppAudioMessageCall(
      WhatsAppAudioMessage whatsAppAudioMessage, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = whatsAppAudioMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/audio";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppAudioMessageValidateBeforeCall(
      WhatsAppAudioMessage whatsAppAudioMessage, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'whatsAppAudioMessage' is set
    if (whatsAppAudioMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppAudioMessage' when calling"
              + " sendWhatsAppAudioMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppAudioMessageCall(whatsAppAudioMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp audio message. Send an audio to a single recipient. Audio messages can only be
   * successfully delivered, if the recipient has contacted the business within the last 24 hours,
   * otherwise template message should be used.
   *
   * @param whatsAppAudioMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppAudioMessage(
      WhatsAppAudioMessage whatsAppAudioMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppAudioMessageWithHttpInfo(whatsAppAudioMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp audio message. Send an audio to a single recipient. Audio messages can only be
   * successfully delivered, if the recipient has contacted the business within the last 24 hours,
   * otherwise template message should be used.
   *
   * @param whatsAppAudioMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppAudioMessageWithHttpInfo(
      WhatsAppAudioMessage whatsAppAudioMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppAudioMessageValidateBeforeCall(whatsAppAudioMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp audio message (asynchronously). Send an audio to a single recipient. Audio
   * messages can only be successfully delivered, if the recipient has contacted the business within
   * the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppAudioMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppAudioMessageAsync(
      WhatsAppAudioMessage whatsAppAudioMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppAudioMessageValidateBeforeCall(whatsAppAudioMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppContactMessage.
   *
   * @param whatsAppContactsMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppContactMessageCall(
      WhatsAppContactsMessage whatsAppContactsMessage, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = whatsAppContactsMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/contact";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppContactMessageValidateBeforeCall(
      WhatsAppContactsMessage whatsAppContactsMessage, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'whatsAppContactsMessage' is set
    if (whatsAppContactsMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppContactsMessage' when calling"
              + " sendWhatsAppContactMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppContactMessageCall(whatsAppContactsMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp contact message. Send a contact to a single recipient. Contact messages can only
   * be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppContactsMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppContactMessage(
      WhatsAppContactsMessage whatsAppContactsMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppContactMessageWithHttpInfo(whatsAppContactsMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp contact message. Send a contact to a single recipient. Contact messages can only
   * be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppContactsMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppContactMessageWithHttpInfo(
      WhatsAppContactsMessage whatsAppContactsMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppContactMessageValidateBeforeCall(whatsAppContactsMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp contact message (asynchronously). Send a contact to a single recipient. Contact
   * messages can only be successfully delivered, if the recipient has contacted the business within
   * the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppContactsMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppContactMessageAsync(
      WhatsAppContactsMessage whatsAppContactsMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppContactMessageValidateBeforeCall(whatsAppContactsMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppDocumentMessage.
   *
   * @param whatsAppDocumentMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppDocumentMessageCall(
      WhatsAppDocumentMessage whatsAppDocumentMessage, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = whatsAppDocumentMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/document";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppDocumentMessageValidateBeforeCall(
      WhatsAppDocumentMessage whatsAppDocumentMessage, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'whatsAppDocumentMessage' is set
    if (whatsAppDocumentMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppDocumentMessage' when calling"
              + " sendWhatsAppDocumentMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppDocumentMessageCall(whatsAppDocumentMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp document message. Send a document to a single recipient. Document messages can
   * only be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppDocumentMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppDocumentMessage(
      WhatsAppDocumentMessage whatsAppDocumentMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppDocumentMessageWithHttpInfo(whatsAppDocumentMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp document message. Send a document to a single recipient. Document messages can
   * only be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppDocumentMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppDocumentMessageWithHttpInfo(
      WhatsAppDocumentMessage whatsAppDocumentMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppDocumentMessageValidateBeforeCall(whatsAppDocumentMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp document message (asynchronously). Send a document to a single recipient.
   * Document messages can only be successfully delivered, if the recipient has contacted the
   * business within the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppDocumentMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppDocumentMessageAsync(
      WhatsAppDocumentMessage whatsAppDocumentMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppDocumentMessageValidateBeforeCall(whatsAppDocumentMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppImageMessage.
   *
   * @param whatsAppImageMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppImageMessageCall(
      WhatsAppImageMessage whatsAppImageMessage, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = whatsAppImageMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/image";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppImageMessageValidateBeforeCall(
      WhatsAppImageMessage whatsAppImageMessage, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'whatsAppImageMessage' is set
    if (whatsAppImageMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppImageMessage' when calling"
              + " sendWhatsAppImageMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppImageMessageCall(whatsAppImageMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp image message. Send an image to a single recipient. Image messages can only be
   * successfully delivered, if the recipient has contacted the business within the last 24 hours,
   * otherwise template message should be used.
   *
   * @param whatsAppImageMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppImageMessage(
      WhatsAppImageMessage whatsAppImageMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppImageMessageWithHttpInfo(whatsAppImageMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp image message. Send an image to a single recipient. Image messages can only be
   * successfully delivered, if the recipient has contacted the business within the last 24 hours,
   * otherwise template message should be used.
   *
   * @param whatsAppImageMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppImageMessageWithHttpInfo(
      WhatsAppImageMessage whatsAppImageMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppImageMessageValidateBeforeCall(whatsAppImageMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp image message (asynchronously). Send an image to a single recipient. Image
   * messages can only be successfully delivered, if the recipient has contacted the business within
   * the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppImageMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppImageMessageAsync(
      WhatsAppImageMessage whatsAppImageMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppImageMessageValidateBeforeCall(whatsAppImageMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppInteractiveButtonsMessage.
   *
   * @param whatsAppInteractiveButtonsMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppInteractiveButtonsMessageCall(
      WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage,
      final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = whatsAppInteractiveButtonsMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/interactive/buttons";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppInteractiveButtonsMessageValidateBeforeCall(
      WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage,
      final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'whatsAppInteractiveButtonsMessage' is set
    if (whatsAppInteractiveButtonsMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppInteractiveButtonsMessage' when calling"
              + " sendWhatsAppInteractiveButtonsMessage(Async)");
    }

    okhttp3.Call localVarCall =
        sendWhatsAppInteractiveButtonsMessageCall(whatsAppInteractiveButtonsMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp interactive buttons message. Send an interactive buttons message to a single
   * recipient. Interactive buttons messages can only be successfully delivered, if the recipient
   * has contacted the business within the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppInteractiveButtonsMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppInteractiveButtonsMessage(
      WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppInteractiveButtonsMessageWithHttpInfo(whatsAppInteractiveButtonsMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp interactive buttons message. Send an interactive buttons message to a single
   * recipient. Interactive buttons messages can only be successfully delivered, if the recipient
   * has contacted the business within the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppInteractiveButtonsMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppInteractiveButtonsMessageWithHttpInfo(
      WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppInteractiveButtonsMessageValidateBeforeCall(
            whatsAppInteractiveButtonsMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp interactive buttons message (asynchronously). Send an interactive buttons message
   * to a single recipient. Interactive buttons messages can only be successfully delivered, if the
   * recipient has contacted the business within the last 24 hours, otherwise template message
   * should be used.
   *
   * @param whatsAppInteractiveButtonsMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppInteractiveButtonsMessageAsync(
      WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppInteractiveButtonsMessageValidateBeforeCall(
            whatsAppInteractiveButtonsMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppInteractiveListMessage.
   *
   * @param whatsAppInteractiveListMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppInteractiveListMessageCall(
      WhatsAppInteractiveListMessage whatsAppInteractiveListMessage, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = whatsAppInteractiveListMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/interactive/list";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppInteractiveListMessageValidateBeforeCall(
      WhatsAppInteractiveListMessage whatsAppInteractiveListMessage, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'whatsAppInteractiveListMessage' is set
    if (whatsAppInteractiveListMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppInteractiveListMessage' when calling"
              + " sendWhatsAppInteractiveListMessage(Async)");
    }

    okhttp3.Call localVarCall =
        sendWhatsAppInteractiveListMessageCall(whatsAppInteractiveListMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp interactive list message. Send an interactive list message to a single recipient.
   * Interactive list messages can only be successfully delivered, if the recipient has contacted
   * the business within the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppInteractiveListMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppInteractiveListMessage(
      WhatsAppInteractiveListMessage whatsAppInteractiveListMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppInteractiveListMessageWithHttpInfo(whatsAppInteractiveListMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp interactive list message. Send an interactive list message to a single recipient.
   * Interactive list messages can only be successfully delivered, if the recipient has contacted
   * the business within the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppInteractiveListMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppInteractiveListMessageWithHttpInfo(
      WhatsAppInteractiveListMessage whatsAppInteractiveListMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppInteractiveListMessageValidateBeforeCall(whatsAppInteractiveListMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp interactive list message (asynchronously). Send an interactive list message to a
   * single recipient. Interactive list messages can only be successfully delivered, if the
   * recipient has contacted the business within the last 24 hours, otherwise template message
   * should be used.
   *
   * @param whatsAppInteractiveListMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppInteractiveListMessageAsync(
      WhatsAppInteractiveListMessage whatsAppInteractiveListMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppInteractiveListMessageValidateBeforeCall(
            whatsAppInteractiveListMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppLocationMessage.
   *
   * @param whatsAppLocationMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppLocationMessageCall(
      WhatsAppLocationMessage whatsAppLocationMessage, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = whatsAppLocationMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/location";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppLocationMessageValidateBeforeCall(
      WhatsAppLocationMessage whatsAppLocationMessage, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'whatsAppLocationMessage' is set
    if (whatsAppLocationMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppLocationMessage' when calling"
              + " sendWhatsAppLocationMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppLocationMessageCall(whatsAppLocationMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp location message. Send a location to a single recipient. Location messages can
   * only be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppLocationMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppLocationMessage(
      WhatsAppLocationMessage whatsAppLocationMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppLocationMessageWithHttpInfo(whatsAppLocationMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp location message. Send a location to a single recipient. Location messages can
   * only be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppLocationMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppLocationMessageWithHttpInfo(
      WhatsAppLocationMessage whatsAppLocationMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppLocationMessageValidateBeforeCall(whatsAppLocationMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp location message (asynchronously). Send a location to a single recipient.
   * Location messages can only be successfully delivered, if the recipient has contacted the
   * business within the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppLocationMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppLocationMessageAsync(
      WhatsAppLocationMessage whatsAppLocationMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppLocationMessageValidateBeforeCall(whatsAppLocationMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppStickerMessage.
   *
   * @param whatsAppStickerMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppStickerMessageCall(
      WhatsAppStickerMessage whatsAppStickerMessage, final ApiCallback _callback)
      throws ApiException {
    Object localVarPostBody = whatsAppStickerMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/sticker";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppStickerMessageValidateBeforeCall(
      WhatsAppStickerMessage whatsAppStickerMessage, final ApiCallback _callback)
      throws ApiException {

    // verify the required parameter 'whatsAppStickerMessage' is set
    if (whatsAppStickerMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppStickerMessage' when calling"
              + " sendWhatsAppStickerMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppStickerMessageCall(whatsAppStickerMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp sticker message. Send a sticker to a single recipient. Sticker messages can only
   * be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppStickerMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppStickerMessage(
      WhatsAppStickerMessage whatsAppStickerMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppStickerMessageWithHttpInfo(whatsAppStickerMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp sticker message. Send a sticker to a single recipient. Sticker messages can only
   * be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppStickerMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppStickerMessageWithHttpInfo(
      WhatsAppStickerMessage whatsAppStickerMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppStickerMessageValidateBeforeCall(whatsAppStickerMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp sticker message (asynchronously). Send a sticker to a single recipient. Sticker
   * messages can only be successfully delivered, if the recipient has contacted the business within
   * the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppStickerMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppStickerMessageAsync(
      WhatsAppStickerMessage whatsAppStickerMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppStickerMessageValidateBeforeCall(whatsAppStickerMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppTemplateMessage.
   *
   * @param whatsAppBulkMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppTemplateMessageCall(
      WhatsAppBulkMessage whatsAppBulkMessage, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = whatsAppBulkMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/template";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppTemplateMessageValidateBeforeCall(
      WhatsAppBulkMessage whatsAppBulkMessage, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'whatsAppBulkMessage' is set
    if (whatsAppBulkMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppBulkMessage' when calling"
              + " sendWhatsAppTemplateMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppTemplateMessageCall(whatsAppBulkMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp template message. Send a single or multiple template messages to a one or more
   * recipients. Template messages can be sent and delivered at anytime. Each template sent needs to
   * be registered and pre-approved by WhatsApp.
   *
   * @param whatsAppBulkMessage (required)
   * @return WhatsAppBulkMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppBulkMessageInfo sendWhatsAppTemplateMessage(
      WhatsAppBulkMessage whatsAppBulkMessage) throws ApiException {
    ApiResponse<WhatsAppBulkMessageInfo> localVarResp =
        sendWhatsAppTemplateMessageWithHttpInfo(whatsAppBulkMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp template message. Send a single or multiple template messages to a one or more
   * recipients. Template messages can be sent and delivered at anytime. Each template sent needs to
   * be registered and pre-approved by WhatsApp.
   *
   * @param whatsAppBulkMessage (required)
   * @return ApiResponse&lt;WhatsAppBulkMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppBulkMessageInfo> sendWhatsAppTemplateMessageWithHttpInfo(
      WhatsAppBulkMessage whatsAppBulkMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppTemplateMessageValidateBeforeCall(whatsAppBulkMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppBulkMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp template message (asynchronously). Send a single or multiple template messages to
   * a one or more recipients. Template messages can be sent and delivered at anytime. Each template
   * sent needs to be registered and pre-approved by WhatsApp.
   *
   * @param whatsAppBulkMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppTemplateMessageAsync(
      WhatsAppBulkMessage whatsAppBulkMessage, final ApiCallback<WhatsAppBulkMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppTemplateMessageValidateBeforeCall(whatsAppBulkMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppBulkMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppTextMessage.
   *
   * @param whatsAppTextMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppTextMessageCall(
      WhatsAppTextMessage whatsAppTextMessage, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = whatsAppTextMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/text";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppTextMessageValidateBeforeCall(
      WhatsAppTextMessage whatsAppTextMessage, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'whatsAppTextMessage' is set
    if (whatsAppTextMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppTextMessage' when calling"
              + " sendWhatsAppTextMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppTextMessageCall(whatsAppTextMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp text message. Send a text message to a single recipient. Text messages can only
   * be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppTextMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppTextMessage(WhatsAppTextMessage whatsAppTextMessage)
      throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppTextMessageWithHttpInfo(whatsAppTextMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp text message. Send a text message to a single recipient. Text messages can only
   * be successfully delivered, if the recipient has contacted the business within the last 24
   * hours, otherwise template message should be used.
   *
   * @param whatsAppTextMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppTextMessageWithHttpInfo(
      WhatsAppTextMessage whatsAppTextMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppTextMessageValidateBeforeCall(whatsAppTextMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp text message (asynchronously). Send a text message to a single recipient. Text
   * messages can only be successfully delivered, if the recipient has contacted the business within
   * the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppTextMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppTextMessageAsync(
      WhatsAppTextMessage whatsAppTextMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppTextMessageValidateBeforeCall(whatsAppTextMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
  /**
   * Build call for sendWhatsAppVideoMessage.
   *
   * @param whatsAppVideoMessage (required)
   * @param _callback Callback for upload/download progress
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppVideoMessageCall(
      WhatsAppVideoMessage whatsAppVideoMessage, final ApiCallback _callback) throws ApiException {
    Object localVarPostBody = whatsAppVideoMessage;

    // create path and map variables
    String localVarPath = "/whatsapp/1/message/video";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) {
      localVarHeaderParams.put("Accept", localVarAccept);
    }

    final String[] localVarContentTypes = {"application/json"};
    final String localVarContentType =
        localVarApiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    String[] localVarAuthNames =
        new String[] {"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
    return localVarApiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAuthNames,
        _callback);
  }

  @SuppressWarnings("rawtypes")
  private okhttp3.Call sendWhatsAppVideoMessageValidateBeforeCall(
      WhatsAppVideoMessage whatsAppVideoMessage, final ApiCallback _callback) throws ApiException {

    // verify the required parameter 'whatsAppVideoMessage' is set
    if (whatsAppVideoMessage == null) {
      throw new ApiException(
          "Missing the required parameter 'whatsAppVideoMessage' when calling"
              + " sendWhatsAppVideoMessage(Async)");
    }

    okhttp3.Call localVarCall = sendWhatsAppVideoMessageCall(whatsAppVideoMessage, _callback);
    return localVarCall;
  }

  /**
   * Send WhatsApp video message. Send a video to a single recipient. Video messages can only be
   * successfully delivered, if the recipient has contacted the business within the last 24 hours,
   * otherwise template message should be used.
   *
   * @param whatsAppVideoMessage (required)
   * @return WhatsAppSingleMessageInfo
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public WhatsAppSingleMessageInfo sendWhatsAppVideoMessage(
      WhatsAppVideoMessage whatsAppVideoMessage) throws ApiException {
    ApiResponse<WhatsAppSingleMessageInfo> localVarResp =
        sendWhatsAppVideoMessageWithHttpInfo(whatsAppVideoMessage);
    return localVarResp.getData();
  }

  /**
   * Send WhatsApp video message. Send a video to a single recipient. Video messages can only be
   * successfully delivered, if the recipient has contacted the business within the last 24 hours,
   * otherwise template message should be used.
   *
   * @param whatsAppVideoMessage (required)
   * @return ApiResponse&lt;WhatsAppSingleMessageInfo&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public ApiResponse<WhatsAppSingleMessageInfo> sendWhatsAppVideoMessageWithHttpInfo(
      WhatsAppVideoMessage whatsAppVideoMessage) throws ApiException {
    okhttp3.Call localVarCall =
        sendWhatsAppVideoMessageValidateBeforeCall(whatsAppVideoMessage, null);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    return localVarApiClient.execute(localVarCall, localVarReturnType);
  }

  /**
   * Send WhatsApp video message (asynchronously). Send a video to a single recipient. Video
   * messages can only be successfully delivered, if the recipient has contacted the business within
   * the last 24 hours, otherwise template message should be used.
   *
   * @param whatsAppVideoMessage (required)
   * @param _callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   * @see <a href="https://www.infobip.com/docs/whatsapp">Learn more about WhatsApp channel and use
   *     cases</a>
   */
  public okhttp3.Call sendWhatsAppVideoMessageAsync(
      WhatsAppVideoMessage whatsAppVideoMessage,
      final ApiCallback<WhatsAppSingleMessageInfo> _callback)
      throws ApiException {

    okhttp3.Call localVarCall =
        sendWhatsAppVideoMessageValidateBeforeCall(whatsAppVideoMessage, _callback);
    Type localVarReturnType = new TypeToken<WhatsAppSingleMessageInfo>() {}.getType();
    localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
    return localVarCall;
  }
}
