/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** SmsAdvancedBinaryRequest */
public class SmsAdvancedBinaryRequest {
  public static final String SERIALIZED_NAME_BULK_ID = "bulkId";

  @SerializedName(SERIALIZED_NAME_BULK_ID)
  private String bulkId;

  public static final String SERIALIZED_NAME_MESSAGES = "messages";

  @SerializedName(SERIALIZED_NAME_MESSAGES)
  private List<SmsBinaryMessage> messages = new ArrayList<>();

  public static final String SERIALIZED_NAME_SENDING_SPEED_LIMIT = "sendingSpeedLimit";

  @SerializedName(SERIALIZED_NAME_SENDING_SPEED_LIMIT)
  private SmsSendingSpeedLimit sendingSpeedLimit = null;

  public SmsAdvancedBinaryRequest bulkId(String bulkId) {

    this.bulkId = bulkId;
    return this;
  }

  /**
   * Unique ID assigned to the request if messaging multiple recipients or sending multiple messages
   * via a single API request. If not provided, it will be auto-generated and returned in the API
   * response. Typically, used to fetch [delivery
   * reports](#channels/sms/get-outbound-sms-message-delivery-reports) and [message
   * logs](#channels/sms/get-outbound-sms-message-logs).
   *
   * @return bulkId
   */
  public String getBulkId() {
    return bulkId;
  }

  public void setBulkId(String bulkId) {
    this.bulkId = bulkId;
  }

  public SmsAdvancedBinaryRequest messages(List<SmsBinaryMessage> messages) {

    this.messages = messages;
    return this;
  }

  public SmsAdvancedBinaryRequest addMessagesItem(SmsBinaryMessage messagesItem) {
    this.messages.add(messagesItem);
    return this;
  }

  /**
   * An array of message objects of a single message or multiple messages sent under one bulk ID.
   *
   * @return messages
   */
  public List<SmsBinaryMessage> getMessages() {
    return messages;
  }

  public void setMessages(List<SmsBinaryMessage> messages) {
    this.messages = messages;
  }

  public SmsAdvancedBinaryRequest sendingSpeedLimit(SmsSendingSpeedLimit sendingSpeedLimit) {

    this.sendingSpeedLimit = sendingSpeedLimit;
    return this;
  }

  /**
   * Limits the send speed when sending messages in bulk to deliver messages over a longer period of
   * time. You may wish to use this to allow your systems or agents to handle large amounts of
   * incoming traffic, e.g., if you are expecting recipients to follow through with a call-to-action
   * option from a message you sent. Not setting a send speed limit can overwhelm your resources
   * with incoming traffic.
   *
   * @return sendingSpeedLimit
   */
  public SmsSendingSpeedLimit getSendingSpeedLimit() {
    return sendingSpeedLimit;
  }

  public void setSendingSpeedLimit(SmsSendingSpeedLimit sendingSpeedLimit) {
    this.sendingSpeedLimit = sendingSpeedLimit;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmsAdvancedBinaryRequest smsAdvancedBinaryRequest = (SmsAdvancedBinaryRequest) o;
    return Objects.equals(this.bulkId, smsAdvancedBinaryRequest.bulkId)
        && Objects.equals(this.messages, smsAdvancedBinaryRequest.messages)
        && Objects.equals(this.sendingSpeedLimit, smsAdvancedBinaryRequest.sendingSpeedLimit);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bulkId, messages, sendingSpeedLimit);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmsAdvancedBinaryRequest {\n");
    sb.append("    bulkId: ").append(toIndentedString(bulkId)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    sendingSpeedLimit: ").append(toIndentedString(sendingSpeedLimit)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
