/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.time.OffsetDateTime;
import java.util.Objects;

/** SmsReport */
public class SmsReport {
  public static final String SERIALIZED_NAME_BULK_ID = "bulkId";

  @SerializedName(SERIALIZED_NAME_BULK_ID)
  private String bulkId;

  public static final String SERIALIZED_NAME_CALLBACK_DATA = "callbackData";

  @SerializedName(SERIALIZED_NAME_CALLBACK_DATA)
  private String callbackData;

  public static final String SERIALIZED_NAME_DONE_AT = "doneAt";

  @SerializedName(SERIALIZED_NAME_DONE_AT)
  private OffsetDateTime doneAt;

  public static final String SERIALIZED_NAME_ERROR = "error";

  @SerializedName(SERIALIZED_NAME_ERROR)
  private SmsError error = null;

  public static final String SERIALIZED_NAME_FROM = "from";

  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_MCC_MNC = "mccMnc";

  @SerializedName(SERIALIZED_NAME_MCC_MNC)
  private String mccMnc;

  public static final String SERIALIZED_NAME_MESSAGE_ID = "messageId";

  @SerializedName(SERIALIZED_NAME_MESSAGE_ID)
  private String messageId;

  public static final String SERIALIZED_NAME_PRICE = "price";

  @SerializedName(SERIALIZED_NAME_PRICE)
  private SmsPrice price = null;

  public static final String SERIALIZED_NAME_SENT_AT = "sentAt";

  @SerializedName(SERIALIZED_NAME_SENT_AT)
  private OffsetDateTime sentAt;

  public static final String SERIALIZED_NAME_SMS_COUNT = "smsCount";

  @SerializedName(SERIALIZED_NAME_SMS_COUNT)
  private Integer smsCount;

  public static final String SERIALIZED_NAME_STATUS = "status";

  @SerializedName(SERIALIZED_NAME_STATUS)
  private SmsStatus status = null;

  public static final String SERIALIZED_NAME_TO = "to";

  @SerializedName(SERIALIZED_NAME_TO)
  private String to;

  /**
   * Unique ID assigned to the request if messaging multiple recipients or sending multiple messages
   * via a single API request.
   *
   * @return bulkId
   */
  public String getBulkId() {
    return bulkId;
  }

  /**
   * Custom data sent over to the &#x60;notifyUrl&#x60;.
   *
   * @return callbackData
   */
  public String getCallbackData() {
    return callbackData;
  }

  /**
   * Date and time when the Infobip services finished processing the message (i.e., delivered to the
   * destination, delivered to the destination network, etc.). Has the following format:
   * &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   *
   * @return doneAt
   */
  public OffsetDateTime getDoneAt() {
    return doneAt;
  }

  /**
   * Indicates whether an error occurred during the query execution.
   *
   * @return error
   */
  public SmsError getError() {
    return error;
  }

  /**
   * The sender ID which can be alphanumeric or numeric (e.g., &#x60;CompanyName&#x60;).
   *
   * @return from
   */
  public String getFrom() {
    return from;
  }

  /**
   * Mobile country and network codes.
   *
   * @return mccMnc
   */
  public String getMccMnc() {
    return mccMnc;
  }

  /**
   * Unique message ID.
   *
   * @return messageId
   */
  public String getMessageId() {
    return messageId;
  }

  /**
   * Sent SMS price.
   *
   * @return price
   */
  public SmsPrice getPrice() {
    return price;
  }

  /**
   * Date and time when the message was [scheduled](#channels/sms/get-scheduled-sms-messages) to be
   * sent. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   *
   * @return sentAt
   */
  public OffsetDateTime getSentAt() {
    return sentAt;
  }

  /**
   * The number of parts the message content was split into.
   *
   * @return smsCount
   */
  public Integer getSmsCount() {
    return smsCount;
  }

  /**
   * Indicates the
   * [status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes)
   * of the message and how to recover from an error should there be any.
   *
   * @return status
   */
  public SmsStatus getStatus() {
    return status;
  }

  /**
   * Message destination address.
   *
   * @return to
   */
  public String getTo() {
    return to;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmsReport smsReport = (SmsReport) o;
    return Objects.equals(this.bulkId, smsReport.bulkId)
        && Objects.equals(this.callbackData, smsReport.callbackData)
        && Objects.equals(this.doneAt, smsReport.doneAt)
        && Objects.equals(this.error, smsReport.error)
        && Objects.equals(this.from, smsReport.from)
        && Objects.equals(this.mccMnc, smsReport.mccMnc)
        && Objects.equals(this.messageId, smsReport.messageId)
        && Objects.equals(this.price, smsReport.price)
        && Objects.equals(this.sentAt, smsReport.sentAt)
        && Objects.equals(this.smsCount, smsReport.smsCount)
        && Objects.equals(this.status, smsReport.status)
        && Objects.equals(this.to, smsReport.to);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        bulkId,
        callbackData,
        doneAt,
        error,
        from,
        mccMnc,
        messageId,
        price,
        sentAt,
        smsCount,
        status,
        to);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmsReport {\n");
    sb.append("    bulkId: ").append(toIndentedString(bulkId)).append("\n");
    sb.append("    callbackData: ").append(toIndentedString(callbackData)).append("\n");
    sb.append("    doneAt: ").append(toIndentedString(doneAt)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    mccMnc: ").append(toIndentedString(mccMnc)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    sentAt: ").append(toIndentedString(sentAt)).append("\n");
    sb.append("    smsCount: ").append(toIndentedString(smsCount)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
