/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Objects;

/** SmsResponse */
public class SmsResponse {
  public static final String SERIALIZED_NAME_BULK_ID = "bulkId";

  @SerializedName(SERIALIZED_NAME_BULK_ID)
  private String bulkId;

  public static final String SERIALIZED_NAME_MESSAGES = "messages";

  @SerializedName(SERIALIZED_NAME_MESSAGES)
  private List<SmsResponseDetails> messages = null;

  /**
   * Unique ID assigned to the request if messaging multiple recipients or sending multiple messages
   * via a single API request. Typically, used to fetch [delivery
   * reports](#channels/sms/get-outbound-sms-message-delivery-reports) and [message
   * logs](#channels/sms/get-outbound-sms-message-logs).
   *
   * @return bulkId
   */
  public String getBulkId() {
    return bulkId;
  }

  /**
   * An array of message objects of a single message or multiple messages sent under one bulk ID.
   *
   * @return messages
   */
  public List<SmsResponseDetails> getMessages() {
    return messages;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmsResponse smsResponse = (SmsResponse) o;
    return Objects.equals(this.bulkId, smsResponse.bulkId)
        && Objects.equals(this.messages, smsResponse.messages);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bulkId, messages);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmsResponse {\n");
    sb.append("    bulkId: ").append(toIndentedString(bulkId)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
