/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** SmsStatus */
public class SmsStatus {
  public static final String SERIALIZED_NAME_ACTION = "action";

  @SerializedName(SERIALIZED_NAME_ACTION)
  private String action;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";

  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_GROUP_ID = "groupId";

  @SerializedName(SERIALIZED_NAME_GROUP_ID)
  private Integer groupId;

  public static final String SERIALIZED_NAME_GROUP_NAME = "groupName";

  @SerializedName(SERIALIZED_NAME_GROUP_NAME)
  private String groupName;

  public static final String SERIALIZED_NAME_ID = "id";

  @SerializedName(SERIALIZED_NAME_ID)
  private Integer id;

  public static final String SERIALIZED_NAME_NAME = "name";

  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * Action that should be taken to recover from the error.
   *
   * @return action
   */
  public String getAction() {
    return action;
  }

  /**
   * Human-readable description of the status.
   *
   * @return description
   */
  public String getDescription() {
    return description;
  }

  /**
   * Status group ID.
   *
   * @return groupId
   */
  public Integer getGroupId() {
    return groupId;
  }

  /**
   * Status group name that describes which category the status code belongs to, e.g. PENDING,
   * UNDELIVERABLE, DELIVERED, EXPIRED, REJECTED.
   *
   * @return groupName
   */
  public String getGroupName() {
    return groupName;
  }

  /**
   * Status ID.
   *
   * @return id
   */
  public Integer getId() {
    return id;
  }

  /**
   * [Status name](https://www.infobip.com/docs/essentials/response-status-and-error-codes).
   *
   * @return name
   */
  public String getName() {
    return name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SmsStatus smsStatus = (SmsStatus) o;
    return Objects.equals(this.action, smsStatus.action)
        && Objects.equals(this.description, smsStatus.description)
        && Objects.equals(this.groupId, smsStatus.groupId)
        && Objects.equals(this.groupName, smsStatus.groupName)
        && Objects.equals(this.id, smsStatus.id)
        && Objects.equals(this.name, smsStatus.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(action, description, groupId, groupName, id, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SmsStatus {\n");
    sb.append("    action: ").append(toIndentedString(action)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
