/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** TfaApplicationResponse */
public class TfaApplicationResponse {
  public static final String SERIALIZED_NAME_APPLICATION_ID = "applicationId";

  @SerializedName(SERIALIZED_NAME_APPLICATION_ID)
  private String applicationId;

  public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";

  @SerializedName(SERIALIZED_NAME_CONFIGURATION)
  private TfaApplicationConfiguration _configuration = null;

  public static final String SERIALIZED_NAME_ENABLED = "enabled";

  @SerializedName(SERIALIZED_NAME_ENABLED)
  private Boolean enabled;

  public static final String SERIALIZED_NAME_NAME = "name";

  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * The ID of the application that represents your service, e.g. 2FA for login, 2FA for changing
   * the password, etc.
   *
   * @return applicationId
   */
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * Created 2FA application configuration.
   *
   * @return _configuration
   */
  public TfaApplicationConfiguration getConfiguration() {
    return _configuration;
  }

  /**
   * Indicates whether the created application is enabled.
   *
   * @return enabled
   */
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * 2FA application name.
   *
   * @return name
   */
  public String getName() {
    return name;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TfaApplicationResponse tfaApplicationResponse = (TfaApplicationResponse) o;
    return Objects.equals(this.applicationId, tfaApplicationResponse.applicationId)
        && Objects.equals(this._configuration, tfaApplicationResponse._configuration)
        && Objects.equals(this.enabled, tfaApplicationResponse.enabled)
        && Objects.equals(this.name, tfaApplicationResponse.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicationId, _configuration, enabled, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TfaApplicationResponse {\n");
    sb.append("    applicationId: ").append(toIndentedString(applicationId)).append("\n");
    sb.append("    _configuration: ").append(toIndentedString(_configuration)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
