/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** TfaUpdateMessageRequest */
public class TfaUpdateMessageRequest {
  public static final String SERIALIZED_NAME_LANGUAGE = "language";

  @SerializedName(SERIALIZED_NAME_LANGUAGE)
  private TfaLanguage language = null;

  public static final String SERIALIZED_NAME_MESSAGE_TEXT = "messageText";

  @SerializedName(SERIALIZED_NAME_MESSAGE_TEXT)
  private String messageText;

  public static final String SERIALIZED_NAME_PIN_LENGTH = "pinLength";

  @SerializedName(SERIALIZED_NAME_PIN_LENGTH)
  private Integer pinLength;

  public static final String SERIALIZED_NAME_PIN_TYPE = "pinType";

  @SerializedName(SERIALIZED_NAME_PIN_TYPE)
  private TfaPinType pinType = null;

  public static final String SERIALIZED_NAME_REGIONAL = "regional";

  @SerializedName(SERIALIZED_NAME_REGIONAL)
  private TfaRegionalOptions regional = null;

  public static final String SERIALIZED_NAME_REPEAT_D_T_M_F = "repeatDTMF";

  @SerializedName(SERIALIZED_NAME_REPEAT_D_T_M_F)
  private String repeatDTMF;

  public static final String SERIALIZED_NAME_SENDER_ID = "senderId";

  @SerializedName(SERIALIZED_NAME_SENDER_ID)
  private String senderId;

  public static final String SERIALIZED_NAME_SPEECH_RATE = "speechRate";

  @SerializedName(SERIALIZED_NAME_SPEECH_RATE)
  private Double speechRate;

  public TfaUpdateMessageRequest language(TfaLanguage language) {

    this.language = language;
    return this;
  }

  /**
   * Language code which message is written in. This is used when sending text-to-speech messages.
   * If not defined, it will default to English (&#x60;en&#x60;).
   *
   * @return language
   */
  public TfaLanguage getLanguage() {
    return language;
  }

  public void setLanguage(TfaLanguage language) {
    this.language = language;
  }

  public TfaUpdateMessageRequest messageText(String messageText) {

    this.messageText = messageText;
    return this;
  }

  /**
   * Content of the message being sent which contains at minimum one placeholder for a PIN code
   * (&#x60;{{pin}}&#x60;). Placeholder format is &#x60;{{placeholderName}}&#x60;.
   *
   * @return messageText
   */
  public String getMessageText() {
    return messageText;
  }

  public void setMessageText(String messageText) {
    this.messageText = messageText;
  }

  public TfaUpdateMessageRequest pinLength(Integer pinLength) {

    this.pinLength = pinLength;
    return this;
  }

  /**
   * PIN code length.
   *
   * @return pinLength
   */
  public Integer getPinLength() {
    return pinLength;
  }

  public void setPinLength(Integer pinLength) {
    this.pinLength = pinLength;
  }

  public TfaUpdateMessageRequest pinType(TfaPinType pinType) {

    this.pinType = pinType;
    return this;
  }

  /**
   * The type of PIN code that will be generated and sent as part of a 2FA message.
   *
   * @return pinType
   */
  public TfaPinType getPinType() {
    return pinType;
  }

  public void setPinType(TfaPinType pinType) {
    this.pinType = pinType;
  }

  public TfaUpdateMessageRequest regional(TfaRegionalOptions regional) {

    this.regional = regional;
    return this;
  }

  /**
   * Region-specific parameters, often imposed by local laws. Use this, if country or region that
   * you are sending a message to requires additional information.
   *
   * @return regional
   */
  public TfaRegionalOptions getRegional() {
    return regional;
  }

  public void setRegional(TfaRegionalOptions regional) {
    this.regional = regional;
  }

  public TfaUpdateMessageRequest repeatDTMF(String repeatDTMF) {

    this.repeatDTMF = repeatDTMF;
    return this;
  }

  /**
   * If the PIN is sent as a voice message, the DTMF code allows the recipient to replay the
   * message.
   *
   * @return repeatDTMF
   */
  public String getRepeatDTMF() {
    return repeatDTMF;
  }

  public void setRepeatDTMF(String repeatDTMF) {
    this.repeatDTMF = repeatDTMF;
  }

  public TfaUpdateMessageRequest senderId(String senderId) {

    this.senderId = senderId;
    return this;
  }

  /**
   * The name that will appear as the sender of the 2FA message (e.g. CompanyName).
   *
   * @return senderId
   */
  public String getSenderId() {
    return senderId;
  }

  public void setSenderId(String senderId) {
    this.senderId = senderId;
  }

  public TfaUpdateMessageRequest speechRate(Double speechRate) {

    this.speechRate = speechRate;
    return this;
  }

  /**
   * The speed of narration for messages sent as voice. Supported range is from &#x60;0.5&#x60; to
   * &#x60;2&#x60;.
   *
   * @return speechRate
   */
  public Double getSpeechRate() {
    return speechRate;
  }

  public void setSpeechRate(Double speechRate) {
    this.speechRate = speechRate;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TfaUpdateMessageRequest tfaUpdateMessageRequest = (TfaUpdateMessageRequest) o;
    return Objects.equals(this.language, tfaUpdateMessageRequest.language)
        && Objects.equals(this.messageText, tfaUpdateMessageRequest.messageText)
        && Objects.equals(this.pinLength, tfaUpdateMessageRequest.pinLength)
        && Objects.equals(this.pinType, tfaUpdateMessageRequest.pinType)
        && Objects.equals(this.regional, tfaUpdateMessageRequest.regional)
        && Objects.equals(this.repeatDTMF, tfaUpdateMessageRequest.repeatDTMF)
        && Objects.equals(this.senderId, tfaUpdateMessageRequest.senderId)
        && Objects.equals(this.speechRate, tfaUpdateMessageRequest.speechRate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        language, messageText, pinLength, pinType, regional, repeatDTMF, senderId, speechRate);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TfaUpdateMessageRequest {\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    messageText: ").append(toIndentedString(messageText)).append("\n");
    sb.append("    pinLength: ").append(toIndentedString(pinLength)).append("\n");
    sb.append("    pinType: ").append(toIndentedString(pinType)).append("\n");
    sb.append("    regional: ").append(toIndentedString(regional)).append("\n");
    sb.append("    repeatDTMF: ").append(toIndentedString(repeatDTMF)).append("\n");
    sb.append("    senderId: ").append(toIndentedString(senderId)).append("\n");
    sb.append("    speechRate: ").append(toIndentedString(speechRate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
