/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** WhatsAppBulkMessage */
public class WhatsAppBulkMessage {
  public static final String SERIALIZED_NAME_MESSAGES = "messages";

  @SerializedName(SERIALIZED_NAME_MESSAGES)
  private List<WhatsAppMessage> messages = new ArrayList<>();

  public static final String SERIALIZED_NAME_BULK_ID = "bulkId";

  @SerializedName(SERIALIZED_NAME_BULK_ID)
  private String bulkId;

  public WhatsAppBulkMessage messages(List<WhatsAppMessage> messages) {

    this.messages = messages;
    return this;
  }

  public WhatsAppBulkMessage addMessagesItem(WhatsAppMessage messagesItem) {
    this.messages.add(messagesItem);
    return this;
  }

  /**
   * An array of messages being sent.
   *
   * @return messages
   */
  public List<WhatsAppMessage> getMessages() {
    return messages;
  }

  public void setMessages(List<WhatsAppMessage> messages) {
    this.messages = messages;
  }

  public WhatsAppBulkMessage bulkId(String bulkId) {

    this.bulkId = bulkId;
    return this;
  }

  /**
   * The ID that uniquely identifies the request. Bulk ID will be received only when you send a
   * message to more than one destination address.
   *
   * @return bulkId
   */
  public String getBulkId() {
    return bulkId;
  }

  public void setBulkId(String bulkId) {
    this.bulkId = bulkId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppBulkMessage whatsAppBulkMessage = (WhatsAppBulkMessage) o;
    return Objects.equals(this.messages, whatsAppBulkMessage.messages)
        && Objects.equals(this.bulkId, whatsAppBulkMessage.bulkId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(messages, bulkId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppBulkMessage {\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    bulkId: ").append(toIndentedString(bulkId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
