/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** WhatsAppContact */
public class WhatsAppContact {
  public static final String SERIALIZED_NAME_ADDRESSES = "addresses";

  @SerializedName(SERIALIZED_NAME_ADDRESSES)
  private List<WhatsAppAddress> addresses = null;

  public static final String SERIALIZED_NAME_BIRTHDAY = "birthday";

  @SerializedName(SERIALIZED_NAME_BIRTHDAY)
  private OffsetDateTime birthday;

  public static final String SERIALIZED_NAME_EMAILS = "emails";

  @SerializedName(SERIALIZED_NAME_EMAILS)
  private List<WhatsAppEmail> emails = null;

  public static final String SERIALIZED_NAME_NAME = "name";

  @SerializedName(SERIALIZED_NAME_NAME)
  private WhatsAppName name;

  public static final String SERIALIZED_NAME_ORG = "org";

  @SerializedName(SERIALIZED_NAME_ORG)
  private WhatsAppOrganization org;

  public static final String SERIALIZED_NAME_PHONES = "phones";

  @SerializedName(SERIALIZED_NAME_PHONES)
  private List<WhatsAppPhone> phones = null;

  public static final String SERIALIZED_NAME_URLS = "urls";

  @SerializedName(SERIALIZED_NAME_URLS)
  private List<WhatsAppUrl> urls = null;

  public WhatsAppContact addresses(List<WhatsAppAddress> addresses) {

    this.addresses = addresses;
    return this;
  }

  public WhatsAppContact addAddressesItem(WhatsAppAddress addressesItem) {
    if (this.addresses == null) {
      this.addresses = new ArrayList<>();
    }
    this.addresses.add(addressesItem);
    return this;
  }

  /**
   * Address information.
   *
   * @return addresses
   */
  public List<WhatsAppAddress> getAddresses() {
    return addresses;
  }

  public void setAddresses(List<WhatsAppAddress> addresses) {
    this.addresses = addresses;
  }

  public WhatsAppContact birthday(OffsetDateTime birthday) {

    this.birthday = birthday;
    return this;
  }

  /**
   * Birthday information, YYYY-MM-DD formatted string.
   *
   * @return birthday
   */
  public OffsetDateTime getBirthday() {
    return birthday;
  }

  public void setBirthday(OffsetDateTime birthday) {
    this.birthday = birthday;
  }

  public WhatsAppContact emails(List<WhatsAppEmail> emails) {

    this.emails = emails;
    return this;
  }

  public WhatsAppContact addEmailsItem(WhatsAppEmail emailsItem) {
    if (this.emails == null) {
      this.emails = new ArrayList<>();
    }
    this.emails.add(emailsItem);
    return this;
  }

  /**
   * Email information.
   *
   * @return emails
   */
  public List<WhatsAppEmail> getEmails() {
    return emails;
  }

  public void setEmails(List<WhatsAppEmail> emails) {
    this.emails = emails;
  }

  public WhatsAppContact name(WhatsAppName name) {

    this.name = name;
    return this;
  }

  /**
   * Get name
   *
   * @return name
   */
  public WhatsAppName getName() {
    return name;
  }

  public void setName(WhatsAppName name) {
    this.name = name;
  }

  public WhatsAppContact org(WhatsAppOrganization org) {

    this.org = org;
    return this;
  }

  /**
   * Get org
   *
   * @return org
   */
  public WhatsAppOrganization getOrg() {
    return org;
  }

  public void setOrg(WhatsAppOrganization org) {
    this.org = org;
  }

  public WhatsAppContact phones(List<WhatsAppPhone> phones) {

    this.phones = phones;
    return this;
  }

  public WhatsAppContact addPhonesItem(WhatsAppPhone phonesItem) {
    if (this.phones == null) {
      this.phones = new ArrayList<>();
    }
    this.phones.add(phonesItem);
    return this;
  }

  /**
   * Phone information.
   *
   * @return phones
   */
  public List<WhatsAppPhone> getPhones() {
    return phones;
  }

  public void setPhones(List<WhatsAppPhone> phones) {
    this.phones = phones;
  }

  public WhatsAppContact urls(List<WhatsAppUrl> urls) {

    this.urls = urls;
    return this;
  }

  public WhatsAppContact addUrlsItem(WhatsAppUrl urlsItem) {
    if (this.urls == null) {
      this.urls = new ArrayList<>();
    }
    this.urls.add(urlsItem);
    return this;
  }

  /**
   * URL information.
   *
   * @return urls
   */
  public List<WhatsAppUrl> getUrls() {
    return urls;
  }

  public void setUrls(List<WhatsAppUrl> urls) {
    this.urls = urls;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppContact whatsAppContact = (WhatsAppContact) o;
    return Objects.equals(this.addresses, whatsAppContact.addresses)
        && Objects.equals(this.birthday, whatsAppContact.birthday)
        && Objects.equals(this.emails, whatsAppContact.emails)
        && Objects.equals(this.name, whatsAppContact.name)
        && Objects.equals(this.org, whatsAppContact.org)
        && Objects.equals(this.phones, whatsAppContact.phones)
        && Objects.equals(this.urls, whatsAppContact.urls);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addresses, birthday, emails, name, org, phones, urls);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppContact {\n");
    sb.append("    addresses: ").append(toIndentedString(addresses)).append("\n");
    sb.append("    birthday: ").append(toIndentedString(birthday)).append("\n");
    sb.append("    emails: ").append(toIndentedString(emails)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    org: ").append(toIndentedString(org)).append("\n");
    sb.append("    phones: ").append(toIndentedString(phones)).append("\n");
    sb.append("    urls: ").append(toIndentedString(urls)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
