/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.time.OffsetDateTime;
import java.util.Objects;

/** WhatsAppDeliveryReport */
public class WhatsAppDeliveryReport {
  public static final String SERIALIZED_NAME_BULK_ID = "bulkId";

  @SerializedName(SERIALIZED_NAME_BULK_ID)
  private String bulkId;

  public static final String SERIALIZED_NAME_PRICE = "price";

  @SerializedName(SERIALIZED_NAME_PRICE)
  private MessagePrice price = null;

  public static final String SERIALIZED_NAME_STATUS = "status";

  @SerializedName(SERIALIZED_NAME_STATUS)
  private MessageStatus status = null;

  public static final String SERIALIZED_NAME_ERROR = "error";

  @SerializedName(SERIALIZED_NAME_ERROR)
  private MessageError error = null;

  public static final String SERIALIZED_NAME_MESSAGE_ID = "messageId";

  @SerializedName(SERIALIZED_NAME_MESSAGE_ID)
  private String messageId;

  public static final String SERIALIZED_NAME_DONE_AT = "doneAt";

  @SerializedName(SERIALIZED_NAME_DONE_AT)
  private OffsetDateTime doneAt;

  public static final String SERIALIZED_NAME_MESSAGE_COUNT = "messageCount";

  @SerializedName(SERIALIZED_NAME_MESSAGE_COUNT)
  private Integer messageCount;

  public static final String SERIALIZED_NAME_SENT_AT = "sentAt";

  @SerializedName(SERIALIZED_NAME_SENT_AT)
  private OffsetDateTime sentAt;

  public static final String SERIALIZED_NAME_TO = "to";

  @SerializedName(SERIALIZED_NAME_TO)
  private String to;

  public WhatsAppDeliveryReport bulkId(String bulkId) {

    this.bulkId = bulkId;
    return this;
  }

  /**
   * The ID that uniquely identifies the request.
   *
   * @return bulkId
   */
  public String getBulkId() {
    return bulkId;
  }

  public void setBulkId(String bulkId) {
    this.bulkId = bulkId;
  }

  public WhatsAppDeliveryReport price(MessagePrice price) {

    this.price = price;
    return this;
  }

  /**
   * Sent message price.
   *
   * @return price
   */
  public MessagePrice getPrice() {
    return price;
  }

  public void setPrice(MessagePrice price) {
    this.price = price;
  }

  public WhatsAppDeliveryReport status(MessageStatus status) {

    this.status = status;
    return this;
  }

  /**
   * Indicates whether the message is successfully sent, not sent, delivered, not delivered, waiting
   * for delivery or any other possible status.
   *
   * @return status
   */
  public MessageStatus getStatus() {
    return status;
  }

  public void setStatus(MessageStatus status) {
    this.status = status;
  }

  public WhatsAppDeliveryReport error(MessageError error) {

    this.error = error;
    return this;
  }

  /**
   * Indicates whether the error occurred during the query execution.
   *
   * @return error
   */
  public MessageError getError() {
    return error;
  }

  public void setError(MessageError error) {
    this.error = error;
  }

  public WhatsAppDeliveryReport messageId(String messageId) {

    this.messageId = messageId;
    return this;
  }

  /**
   * The ID that uniquely identifies the message sent.
   *
   * @return messageId
   */
  public String getMessageId() {
    return messageId;
  }

  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  public WhatsAppDeliveryReport doneAt(OffsetDateTime doneAt) {

    this.doneAt = doneAt;
    return this;
  }

  /**
   * Tells when the message was finished processing by Infobip (ie. delivered to destination,
   * delivered to destination network, etc.).
   *
   * @return doneAt
   */
  public OffsetDateTime getDoneAt() {
    return doneAt;
  }

  public void setDoneAt(OffsetDateTime doneAt) {
    this.doneAt = doneAt;
  }

  public WhatsAppDeliveryReport messageCount(Integer messageCount) {

    this.messageCount = messageCount;
    return this;
  }

  /**
   * The number of sent message segments.
   *
   * @return messageCount
   */
  public Integer getMessageCount() {
    return messageCount;
  }

  public void setMessageCount(Integer messageCount) {
    this.messageCount = messageCount;
  }

  public WhatsAppDeliveryReport sentAt(OffsetDateTime sentAt) {

    this.sentAt = sentAt;
    return this;
  }

  /**
   * Tells when the message was sent. Has the following format:
   * &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.
   *
   * @return sentAt
   */
  public OffsetDateTime getSentAt() {
    return sentAt;
  }

  public void setSentAt(OffsetDateTime sentAt) {
    this.sentAt = sentAt;
  }

  public WhatsAppDeliveryReport to(String to) {

    this.to = to;
    return this;
  }

  /**
   * The message destination address.
   *
   * @return to
   */
  public String getTo() {
    return to;
  }

  public void setTo(String to) {
    this.to = to;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppDeliveryReport whatsAppDeliveryReport = (WhatsAppDeliveryReport) o;
    return Objects.equals(this.bulkId, whatsAppDeliveryReport.bulkId)
        && Objects.equals(this.price, whatsAppDeliveryReport.price)
        && Objects.equals(this.status, whatsAppDeliveryReport.status)
        && Objects.equals(this.error, whatsAppDeliveryReport.error)
        && Objects.equals(this.messageId, whatsAppDeliveryReport.messageId)
        && Objects.equals(this.doneAt, whatsAppDeliveryReport.doneAt)
        && Objects.equals(this.messageCount, whatsAppDeliveryReport.messageCount)
        && Objects.equals(this.sentAt, whatsAppDeliveryReport.sentAt)
        && Objects.equals(this.to, whatsAppDeliveryReport.to);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bulkId, price, status, error, messageId, doneAt, messageCount, sentAt, to);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppDeliveryReport {\n");
    sb.append("    bulkId: ").append(toIndentedString(bulkId)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    doneAt: ").append(toIndentedString(doneAt)).append("\n");
    sb.append("    messageCount: ").append(toIndentedString(messageCount)).append("\n");
    sb.append("    sentAt: ").append(toIndentedString(sentAt)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
