/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** WhatsAppInboundLocationMessage */
public class WhatsAppInboundLocationMessage extends WhatsAppInboundMessage {
  public static final String SERIALIZED_NAME_LONGITUDE = "longitude";

  @SerializedName(SERIALIZED_NAME_LONGITUDE)
  private Double longitude;

  public static final String SERIALIZED_NAME_LATITUDE = "latitude";

  @SerializedName(SERIALIZED_NAME_LATITUDE)
  private Double latitude;

  public static final String SERIALIZED_NAME_NAME = "name";

  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_ADDRESS = "address";

  @SerializedName(SERIALIZED_NAME_ADDRESS)
  private String address;

  public static final String SERIALIZED_NAME_URL = "url";

  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public WhatsAppInboundLocationMessage longitude(Double longitude) {

    this.longitude = longitude;
    return this;
  }

  /**
   * Longitude. The value must be between -90 and 90.
   *
   * @return longitude
   */
  public Double getLongitude() {
    return longitude;
  }

  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }

  public WhatsAppInboundLocationMessage latitude(Double latitude) {

    this.latitude = latitude;
    return this;
  }

  /**
   * Latitude. The value must be between -180 and 180.
   *
   * @return latitude
   */
  public Double getLatitude() {
    return latitude;
  }

  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }

  public WhatsAppInboundLocationMessage name(String name) {

    this.name = name;
    return this;
  }

  /**
   * Location name.
   *
   * @return name
   */
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WhatsAppInboundLocationMessage address(String address) {

    this.address = address;
    return this;
  }

  /**
   * Location address.
   *
   * @return address
   */
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public WhatsAppInboundLocationMessage url(String url) {

    this.url = url;
    return this;
  }

  /**
   * Location URL.
   *
   * @return url
   */
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppInboundLocationMessage whatsAppInboundLocationMessage =
        (WhatsAppInboundLocationMessage) o;
    return Objects.equals(this.longitude, whatsAppInboundLocationMessage.longitude)
        && Objects.equals(this.latitude, whatsAppInboundLocationMessage.latitude)
        && Objects.equals(this.name, whatsAppInboundLocationMessage.name)
        && Objects.equals(this.address, whatsAppInboundLocationMessage.address)
        && Objects.equals(this.url, whatsAppInboundLocationMessage.url)
        && super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(longitude, latitude, name, address, url, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppInboundLocationMessage {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
