/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.time.OffsetDateTime;
import java.util.Objects;

/** WhatsAppInboundMessageData */
public class WhatsAppInboundMessageData {
  public static final String SERIALIZED_NAME_FROM = "from";

  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_TO = "to";

  @SerializedName(SERIALIZED_NAME_TO)
  private String to;

  public static final String SERIALIZED_NAME_RECEIVED_AT = "receivedAt";

  @SerializedName(SERIALIZED_NAME_RECEIVED_AT)
  private OffsetDateTime receivedAt;

  public static final String SERIALIZED_NAME_MESSAGE_ID = "messageId";

  @SerializedName(SERIALIZED_NAME_MESSAGE_ID)
  private String messageId;

  public static final String SERIALIZED_NAME_PRICE = "price";

  @SerializedName(SERIALIZED_NAME_PRICE)
  private MessagePrice price = null;

  public static final String SERIALIZED_NAME_MESSAGE = "message";

  @SerializedName(SERIALIZED_NAME_MESSAGE)
  private WhatsAppInboundMessage message;

  public static final String SERIALIZED_NAME_CONTACT = "contact";

  @SerializedName(SERIALIZED_NAME_CONTACT)
  private WhatsAppContactName contact = null;

  public WhatsAppInboundMessageData from(String from) {

    this.from = from;
    return this;
  }

  /**
   * Number which sent the message.
   *
   * @return from
   */
  public String getFrom() {
    return from;
  }

  public void setFrom(String from) {
    this.from = from;
  }

  public WhatsAppInboundMessageData to(String to) {

    this.to = to;
    return this;
  }

  /**
   * Sender provided during the activation process.
   *
   * @return to
   */
  public String getTo() {
    return to;
  }

  public void setTo(String to) {
    this.to = to;
  }

  public WhatsAppInboundMessageData receivedAt(OffsetDateTime receivedAt) {

    this.receivedAt = receivedAt;
    return this;
  }

  /**
   * Tells when Infobip platform received the message.
   *
   * @return receivedAt
   */
  public OffsetDateTime getReceivedAt() {
    return receivedAt;
  }

  public void setReceivedAt(OffsetDateTime receivedAt) {
    this.receivedAt = receivedAt;
  }

  public WhatsAppInboundMessageData messageId(String messageId) {

    this.messageId = messageId;
    return this;
  }

  /**
   * The ID that uniquely identifies the received message.
   *
   * @return messageId
   */
  public String getMessageId() {
    return messageId;
  }

  public void setMessageId(String messageId) {
    this.messageId = messageId;
  }

  public WhatsAppInboundMessageData price(MessagePrice price) {

    this.price = price;
    return this;
  }

  /**
   * Message price.
   *
   * @return price
   */
  public MessagePrice getPrice() {
    return price;
  }

  public void setPrice(MessagePrice price) {
    this.price = price;
  }

  public WhatsAppInboundMessageData message(WhatsAppInboundMessage message) {

    this.message = message;
    return this;
  }

  /**
   * Get message
   *
   * @return message
   */
  public WhatsAppInboundMessage getMessage() {
    return message;
  }

  public void setMessage(WhatsAppInboundMessage message) {
    this.message = message;
  }

  public WhatsAppInboundMessageData contact(WhatsAppContactName contact) {

    this.contact = contact;
    return this;
  }

  /**
   * Information about recipient.
   *
   * @return contact
   */
  public WhatsAppContactName getContact() {
    return contact;
  }

  public void setContact(WhatsAppContactName contact) {
    this.contact = contact;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppInboundMessageData whatsAppInboundMessageData = (WhatsAppInboundMessageData) o;
    return Objects.equals(this.from, whatsAppInboundMessageData.from)
        && Objects.equals(this.to, whatsAppInboundMessageData.to)
        && Objects.equals(this.receivedAt, whatsAppInboundMessageData.receivedAt)
        && Objects.equals(this.messageId, whatsAppInboundMessageData.messageId)
        && Objects.equals(this.price, whatsAppInboundMessageData.price)
        && Objects.equals(this.message, whatsAppInboundMessageData.message)
        && Objects.equals(this.contact, whatsAppInboundMessageData.contact);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, to, receivedAt, messageId, price, message, contact);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppInboundMessageData {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    receivedAt: ").append(toIndentedString(receivedAt)).append("\n");
    sb.append("    messageId: ").append(toIndentedString(messageId)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
