/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** WhatsAppInboundMessageResult */
public class WhatsAppInboundMessageResult {
  public static final String SERIALIZED_NAME_RESULTS = "results";

  @SerializedName(SERIALIZED_NAME_RESULTS)
  private List<WhatsAppInboundMessageData> results = null;

  public static final String SERIALIZED_NAME_MESSAGE_COUNT = "messageCount";

  @SerializedName(SERIALIZED_NAME_MESSAGE_COUNT)
  private Double messageCount;

  public static final String SERIALIZED_NAME_PENDING_MESSAGE_COUNT = "pendingMessageCount";

  @SerializedName(SERIALIZED_NAME_PENDING_MESSAGE_COUNT)
  private Double pendingMessageCount;

  public WhatsAppInboundMessageResult results(List<WhatsAppInboundMessageData> results) {

    this.results = results;
    return this;
  }

  public WhatsAppInboundMessageResult addResultsItem(WhatsAppInboundMessageData resultsItem) {
    if (this.results == null) {
      this.results = new ArrayList<>();
    }
    this.results.add(resultsItem);
    return this;
  }

  /**
   * Collection of reports, one per every received message.
   *
   * @return results
   */
  public List<WhatsAppInboundMessageData> getResults() {
    return results;
  }

  public void setResults(List<WhatsAppInboundMessageData> results) {
    this.results = results;
  }

  public WhatsAppInboundMessageResult messageCount(Double messageCount) {

    this.messageCount = messageCount;
    return this;
  }

  /**
   * Number of returned messages in this request.
   *
   * @return messageCount
   */
  public Double getMessageCount() {
    return messageCount;
  }

  public void setMessageCount(Double messageCount) {
    this.messageCount = messageCount;
  }

  public WhatsAppInboundMessageResult pendingMessageCount(Double pendingMessageCount) {

    this.pendingMessageCount = pendingMessageCount;
    return this;
  }

  /**
   * Number of remaining new messages on Infobip servers ready to be returned in the next request.
   *
   * @return pendingMessageCount
   */
  public Double getPendingMessageCount() {
    return pendingMessageCount;
  }

  public void setPendingMessageCount(Double pendingMessageCount) {
    this.pendingMessageCount = pendingMessageCount;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppInboundMessageResult whatsAppInboundMessageResult = (WhatsAppInboundMessageResult) o;
    return Objects.equals(this.results, whatsAppInboundMessageResult.results)
        && Objects.equals(this.messageCount, whatsAppInboundMessageResult.messageCount)
        && Objects.equals(
            this.pendingMessageCount, whatsAppInboundMessageResult.pendingMessageCount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(results, messageCount, pendingMessageCount);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppInboundMessageResult {\n");
    sb.append("    results: ").append(toIndentedString(results)).append("\n");
    sb.append("    messageCount: ").append(toIndentedString(messageCount)).append("\n");
    sb.append("    pendingMessageCount: ")
        .append(toIndentedString(pendingMessageCount))
        .append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
