/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Message action. */
public class WhatsAppInteractiveListActionContent {
  public static final String SERIALIZED_NAME_TITLE = "title";

  @SerializedName(SERIALIZED_NAME_TITLE)
  private String title;

  public static final String SERIALIZED_NAME_SECTIONS = "sections";

  @SerializedName(SERIALIZED_NAME_SECTIONS)
  private List<WhatsAppInteractiveListSectionContent> sections = new ArrayList<>();

  public WhatsAppInteractiveListActionContent title(String title) {

    this.title = title;
    return this;
  }

  /**
   * Title of the list. Does not allow emojis or markdown.
   *
   * @return title
   */
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public WhatsAppInteractiveListActionContent sections(
      List<WhatsAppInteractiveListSectionContent> sections) {

    this.sections = sections;
    return this;
  }

  public WhatsAppInteractiveListActionContent addSectionsItem(
      WhatsAppInteractiveListSectionContent sectionsItem) {
    this.sections.add(sectionsItem);
    return this;
  }

  /**
   * Array of sections in the list.
   *
   * @return sections
   */
  public List<WhatsAppInteractiveListSectionContent> getSections() {
    return sections;
  }

  public void setSections(List<WhatsAppInteractiveListSectionContent> sections) {
    this.sections = sections;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppInteractiveListActionContent whatsAppInteractiveListActionContent =
        (WhatsAppInteractiveListActionContent) o;
    return Objects.equals(this.title, whatsAppInteractiveListActionContent.title)
        && Objects.equals(this.sections, whatsAppInteractiveListActionContent.sections);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, sections);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppInteractiveListActionContent {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    sections: ").append(toIndentedString(sections)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
