/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** The content object to build a message that will be sent. */
public class WhatsAppLocationContent {
  public static final String SERIALIZED_NAME_LATITUDE = "latitude";

  @SerializedName(SERIALIZED_NAME_LATITUDE)
  private Double latitude;

  public static final String SERIALIZED_NAME_LONGITUDE = "longitude";

  @SerializedName(SERIALIZED_NAME_LONGITUDE)
  private Double longitude;

  public static final String SERIALIZED_NAME_NAME = "name";

  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_ADDRESS = "address";

  @SerializedName(SERIALIZED_NAME_ADDRESS)
  private String address;

  public WhatsAppLocationContent latitude(Double latitude) {

    this.latitude = latitude;
    return this;
  }

  /**
   * Latitude of a location sent in the WhatsApp message. minimum: -90 maximum: 90
   *
   * @return latitude
   */
  public Double getLatitude() {
    return latitude;
  }

  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }

  public WhatsAppLocationContent longitude(Double longitude) {

    this.longitude = longitude;
    return this;
  }

  /**
   * Longitude of a location sent in the WhatsApp message. minimum: -180 maximum: 180
   *
   * @return longitude
   */
  public Double getLongitude() {
    return longitude;
  }

  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }

  public WhatsAppLocationContent name(String name) {

    this.name = name;
    return this;
  }

  /**
   * Location name.
   *
   * @return name
   */
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WhatsAppLocationContent address(String address) {

    this.address = address;
    return this;
  }

  /**
   * Location address.
   *
   * @return address
   */
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppLocationContent whatsAppLocationContent = (WhatsAppLocationContent) o;
    return Objects.equals(this.latitude, whatsAppLocationContent.latitude)
        && Objects.equals(this.longitude, whatsAppLocationContent.longitude)
        && Objects.equals(this.name, whatsAppLocationContent.name)
        && Objects.equals(this.address, whatsAppLocationContent.address);
  }

  @Override
  public int hashCode() {
    return Objects.hash(latitude, longitude, name, address);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppLocationContent {\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
