/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** Full contact name. */
public class WhatsAppName {
  public static final String SERIALIZED_NAME_FIRST_NAME = "firstName";

  @SerializedName(SERIALIZED_NAME_FIRST_NAME)
  private String firstName;

  public static final String SERIALIZED_NAME_FORMATTED_NAME = "formattedName";

  @SerializedName(SERIALIZED_NAME_FORMATTED_NAME)
  private String formattedName;

  public static final String SERIALIZED_NAME_LAST_NAME = "lastName";

  @SerializedName(SERIALIZED_NAME_LAST_NAME)
  private String lastName;

  public static final String SERIALIZED_NAME_MIDDLE_NAME = "middleName";

  @SerializedName(SERIALIZED_NAME_MIDDLE_NAME)
  private String middleName;

  public static final String SERIALIZED_NAME_NAME_SUFFIX = "nameSuffix";

  @SerializedName(SERIALIZED_NAME_NAME_SUFFIX)
  private String nameSuffix;

  public static final String SERIALIZED_NAME_NAME_PREFIX = "namePrefix";

  @SerializedName(SERIALIZED_NAME_NAME_PREFIX)
  private String namePrefix;

  public WhatsAppName firstName(String firstName) {

    this.firstName = firstName;
    return this;
  }

  /**
   * First name of a contact. Mandatory value.
   *
   * @return firstName
   */
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public WhatsAppName formattedName(String formattedName) {

    this.formattedName = formattedName;
    return this;
  }

  /**
   * Full name as it normally appears. Mandatory value.
   *
   * @return formattedName
   */
  public String getFormattedName() {
    return formattedName;
  }

  public void setFormattedName(String formattedName) {
    this.formattedName = formattedName;
  }

  public WhatsAppName lastName(String lastName) {

    this.lastName = lastName;
    return this;
  }

  /**
   * Last name of a contact.
   *
   * @return lastName
   */
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public WhatsAppName middleName(String middleName) {

    this.middleName = middleName;
    return this;
  }

  /**
   * Middle name of a contact.
   *
   * @return middleName
   */
  public String getMiddleName() {
    return middleName;
  }

  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }

  public WhatsAppName nameSuffix(String nameSuffix) {

    this.nameSuffix = nameSuffix;
    return this;
  }

  /**
   * Name suffix of a contact.
   *
   * @return nameSuffix
   */
  public String getNameSuffix() {
    return nameSuffix;
  }

  public void setNameSuffix(String nameSuffix) {
    this.nameSuffix = nameSuffix;
  }

  public WhatsAppName namePrefix(String namePrefix) {

    this.namePrefix = namePrefix;
    return this;
  }

  /**
   * Name prefix of a contact.
   *
   * @return namePrefix
   */
  public String getNamePrefix() {
    return namePrefix;
  }

  public void setNamePrefix(String namePrefix) {
    this.namePrefix = namePrefix;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppName whatsAppName = (WhatsAppName) o;
    return Objects.equals(this.firstName, whatsAppName.firstName)
        && Objects.equals(this.formattedName, whatsAppName.formattedName)
        && Objects.equals(this.lastName, whatsAppName.lastName)
        && Objects.equals(this.middleName, whatsAppName.middleName)
        && Objects.equals(this.nameSuffix, whatsAppName.nameSuffix)
        && Objects.equals(this.namePrefix, whatsAppName.namePrefix);
  }

  @Override
  public int hashCode() {
    return Objects.hash(firstName, formattedName, lastName, middleName, nameSuffix, namePrefix);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppName {\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    formattedName: ").append(toIndentedString(formattedName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    middleName: ").append(toIndentedString(middleName)).append("\n");
    sb.append("    nameSuffix: ").append(toIndentedString(nameSuffix)).append("\n");
    sb.append("    namePrefix: ").append(toIndentedString(namePrefix)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
