/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/** WhatsAppPhone */
public class WhatsAppPhone {
  public static final String SERIALIZED_NAME_PHONE = "phone";

  @SerializedName(SERIALIZED_NAME_PHONE)
  private String phone;

  public static final String SERIALIZED_NAME_WA_ID = "waId";

  @SerializedName(SERIALIZED_NAME_WA_ID)
  private String waId;

  /** Type of a phone. */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    CELL("CELL"),

    MAIN("MAIN"),

    IPHONE("IPHONE"),

    HOME("HOME"),

    WORK("WORK");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration)
          throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";

  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public WhatsAppPhone phone(String phone) {

    this.phone = phone;
    return this;
  }

  /**
   * Contact phone number.
   *
   * @return phone
   */
  public String getPhone() {
    return phone;
  }

  public void setPhone(String phone) {
    this.phone = phone;
  }

  public WhatsAppPhone waId(String waId) {

    this.waId = waId;
    return this;
  }

  /**
   * WhatsApp ID.
   *
   * @return waId
   */
  public String getWaId() {
    return waId;
  }

  public void setWaId(String waId) {
    this.waId = waId;
  }

  public WhatsAppPhone type(TypeEnum type) {

    this.type = type;
    return this;
  }

  /**
   * Type of a phone.
   *
   * @return type
   */
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppPhone whatsAppPhone = (WhatsAppPhone) o;
    return Objects.equals(this.phone, whatsAppPhone.phone)
        && Objects.equals(this.waId, whatsAppPhone.waId)
        && Objects.equals(this.type, whatsAppPhone.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(phone, waId, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppPhone {\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    waId: ").append(toIndentedString(waId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
