/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** Product information included in the incoming message. */
public class WhatsAppReferredProduct {
  public static final String SERIALIZED_NAME_CATALOG_ID = "catalogId";

  @SerializedName(SERIALIZED_NAME_CATALOG_ID)
  private String catalogId;

  public static final String SERIALIZED_NAME_PRODUCT_RETAILER_ID = "productRetailerId";

  @SerializedName(SERIALIZED_NAME_PRODUCT_RETAILER_ID)
  private String productRetailerId;

  public WhatsAppReferredProduct catalogId(String catalogId) {

    this.catalogId = catalogId;
    return this;
  }

  /**
   * The ID that uniquely identifies the catalog registered with Facebook, connected to the WhatsApp
   * Business Account (WABA) the sender belongs to.
   *
   * @return catalogId
   */
  public String getCatalogId() {
    return catalogId;
  }

  public void setCatalogId(String catalogId) {
    this.catalogId = catalogId;
  }

  public WhatsAppReferredProduct productRetailerId(String productRetailerId) {

    this.productRetailerId = productRetailerId;
    return this;
  }

  /**
   * Product unique identifier, as defined in catalog.
   *
   * @return productRetailerId
   */
  public String getProductRetailerId() {
    return productRetailerId;
  }

  public void setProductRetailerId(String productRetailerId) {
    this.productRetailerId = productRetailerId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppReferredProduct whatsAppReferredProduct = (WhatsAppReferredProduct) o;
    return Objects.equals(this.catalogId, whatsAppReferredProduct.catalogId)
        && Objects.equals(this.productRetailerId, whatsAppReferredProduct.productRetailerId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(catalogId, productRetailerId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppReferredProduct {\n");
    sb.append("    catalogId: ").append(toIndentedString(catalogId)).append("\n");
    sb.append("    productRetailerId: ").append(toIndentedString(productRetailerId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
