/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/** List of all templates for given sender. */
public class WhatsAppTemplateApiResponse {
  public static final String SERIALIZED_NAME_ID = "id";

  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_BUSINESS_ACCOUNT_ID = "businessAccountId";

  @SerializedName(SERIALIZED_NAME_BUSINESS_ACCOUNT_ID)
  private Long businessAccountId;

  public static final String SERIALIZED_NAME_NAME = "name";

  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /** Template language, one template with same name can have multiple transliterations. */
  @JsonAdapter(LanguageEnum.Adapter.class)
  public enum LanguageEnum {
    AF("af"),

    SQ("sq"),

    AR("ar"),

    AZ("az"),

    BN("bn"),

    BG("bg"),

    CA("ca"),

    ZH_CN("zh_CN"),

    ZH_HK("zh_HK"),

    ZH_TW("zh_TW"),

    HR("hr"),

    CS("cs"),

    DA("da"),

    NL("nl"),

    EN("en"),

    EN_GB("en_GB"),

    EN_US("en_US"),

    ET("et"),

    FIL("fil"),

    FI("fi"),

    FR("fr"),

    DE("de"),

    EL("el"),

    GU("gu"),

    HA("ha"),

    HE("he"),

    HI("hi"),

    HU("hu"),

    ID("id"),

    GA("ga"),

    IT("it"),

    JA("ja"),

    KN("kn"),

    KK("kk"),

    KO("ko"),

    LO("lo"),

    LV("lv"),

    LT("lt"),

    MK("mk"),

    MS("ms"),

    ML("ml"),

    MR("mr"),

    NB("nb"),

    FA("fa"),

    PL("pl"),

    PT_BR("pt_BR"),

    PT_PT("pt_PT"),

    PA("pa"),

    RO("ro"),

    RU("ru"),

    SR("sr"),

    SK("sk"),

    SL("sl"),

    ES("es"),

    ES_AR("es_AR"),

    ES_ES("es_ES"),

    ES_MX("es_MX"),

    SW("sw"),

    SV("sv"),

    TA("ta"),

    TE("te"),

    TH("th"),

    TR("tr"),

    UK("uk"),

    UR("ur"),

    UZ("uz"),

    VI("vi"),

    UNKNOWN("unknown");

    private String value;

    LanguageEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LanguageEnum fromValue(String value) {
      for (LanguageEnum b : LanguageEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<LanguageEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LanguageEnum enumeration)
          throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LanguageEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return LanguageEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_LANGUAGE = "language";

  @SerializedName(SERIALIZED_NAME_LANGUAGE)
  private LanguageEnum language;

  /** Status of the template. */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    APPROVED("APPROVED"),

    IN_APPEAL("IN_APPEAL"),

    PENDING("PENDING"),

    REJECTED("REJECTED"),

    PENDING_DELETION("PENDING_DELETION"),

    DELETED("DELETED"),

    DISABLED("DISABLED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration)
          throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";

  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  /** Category of the template. */
  @JsonAdapter(CategoryEnum.Adapter.class)
  public enum CategoryEnum {
    ACCOUNT_UPDATE("ACCOUNT_UPDATE"),

    PAYMENT_UPDATE("PAYMENT_UPDATE"),

    PERSONAL_FINANCE_UPDATE("PERSONAL_FINANCE_UPDATE"),

    SHIPPING_UPDATE("SHIPPING_UPDATE"),

    RESERVATION_UPDATE("RESERVATION_UPDATE"),

    ISSUE_RESOLUTION("ISSUE_RESOLUTION"),

    APPOINTMENT_UPDATE("APPOINTMENT_UPDATE"),

    TRANSPORTATION_UPDATE("TRANSPORTATION_UPDATE"),

    TICKET_UPDATE("TICKET_UPDATE"),

    ALERT_UPDATE("ALERT_UPDATE"),

    AUTO_REPLY("AUTO_REPLY");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CategoryEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CategoryEnum enumeration)
          throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CategoryEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return CategoryEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CATEGORY = "category";

  @SerializedName(SERIALIZED_NAME_CATEGORY)
  private CategoryEnum category;

  public static final String SERIALIZED_NAME_STRUCTURE = "structure";

  @SerializedName(SERIALIZED_NAME_STRUCTURE)
  private WhatsAppTemplateStructureApiData structure;

  public WhatsAppTemplateApiResponse id(String id) {

    this.id = id;
    return this;
  }

  /**
   * Template ID.
   *
   * @return id
   */
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public WhatsAppTemplateApiResponse businessAccountId(Long businessAccountId) {

    this.businessAccountId = businessAccountId;
    return this;
  }

  /**
   * Business account ID to which template belongs.
   *
   * @return businessAccountId
   */
  public Long getBusinessAccountId() {
    return businessAccountId;
  }

  public void setBusinessAccountId(Long businessAccountId) {
    this.businessAccountId = businessAccountId;
  }

  public WhatsAppTemplateApiResponse name(String name) {

    this.name = name;
    return this;
  }

  /**
   * Name of the template.
   *
   * @return name
   */
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WhatsAppTemplateApiResponse language(LanguageEnum language) {

    this.language = language;
    return this;
  }

  /**
   * Template language, one template with same name can have multiple transliterations.
   *
   * @return language
   */
  public LanguageEnum getLanguage() {
    return language;
  }

  public void setLanguage(LanguageEnum language) {
    this.language = language;
  }

  public WhatsAppTemplateApiResponse status(StatusEnum status) {

    this.status = status;
    return this;
  }

  /**
   * Status of the template.
   *
   * @return status
   */
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public WhatsAppTemplateApiResponse category(CategoryEnum category) {

    this.category = category;
    return this;
  }

  /**
   * Category of the template.
   *
   * @return category
   */
  public CategoryEnum getCategory() {
    return category;
  }

  public void setCategory(CategoryEnum category) {
    this.category = category;
  }

  public WhatsAppTemplateApiResponse structure(WhatsAppTemplateStructureApiData structure) {

    this.structure = structure;
    return this;
  }

  /**
   * Get structure
   *
   * @return structure
   */
  public WhatsAppTemplateStructureApiData getStructure() {
    return structure;
  }

  public void setStructure(WhatsAppTemplateStructureApiData structure) {
    this.structure = structure;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppTemplateApiResponse whatsAppTemplateApiResponse = (WhatsAppTemplateApiResponse) o;
    return Objects.equals(this.id, whatsAppTemplateApiResponse.id)
        && Objects.equals(this.businessAccountId, whatsAppTemplateApiResponse.businessAccountId)
        && Objects.equals(this.name, whatsAppTemplateApiResponse.name)
        && Objects.equals(this.language, whatsAppTemplateApiResponse.language)
        && Objects.equals(this.status, whatsAppTemplateApiResponse.status)
        && Objects.equals(this.category, whatsAppTemplateApiResponse.category)
        && Objects.equals(this.structure, whatsAppTemplateApiResponse.structure);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, businessAccountId, name, language, status, category, structure);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppTemplateApiResponse {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    businessAccountId: ").append(toIndentedString(businessAccountId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    structure: ").append(toIndentedString(structure)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
