/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** The content object to build a message that will be sent. */
public class WhatsAppTemplateContent {
  public static final String SERIALIZED_NAME_TEMPLATE_NAME = "templateName";

  @SerializedName(SERIALIZED_NAME_TEMPLATE_NAME)
  private String templateName;

  public static final String SERIALIZED_NAME_TEMPLATE_DATA = "templateData";

  @SerializedName(SERIALIZED_NAME_TEMPLATE_DATA)
  private WhatsAppTemplateDataContent templateData;

  public static final String SERIALIZED_NAME_LANGUAGE = "language";

  @SerializedName(SERIALIZED_NAME_LANGUAGE)
  private String language;

  public WhatsAppTemplateContent templateName(String templateName) {

    this.templateName = templateName;
    return this;
  }

  /**
   * Template name. Should only contain lowercase alphanumeric characters and underscores.
   *
   * @return templateName
   */
  public String getTemplateName() {
    return templateName;
  }

  public void setTemplateName(String templateName) {
    this.templateName = templateName;
  }

  public WhatsAppTemplateContent templateData(WhatsAppTemplateDataContent templateData) {

    this.templateData = templateData;
    return this;
  }

  /**
   * Get templateData
   *
   * @return templateData
   */
  public WhatsAppTemplateDataContent getTemplateData() {
    return templateData;
  }

  public void setTemplateData(WhatsAppTemplateDataContent templateData) {
    this.templateData = templateData;
  }

  public WhatsAppTemplateContent language(String language) {

    this.language = language;
    return this;
  }

  /**
   * The code of language or locale to use. Must be the same code used when registering the
   * template.
   *
   * @return language
   */
  public String getLanguage() {
    return language;
  }

  public void setLanguage(String language) {
    this.language = language;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppTemplateContent whatsAppTemplateContent = (WhatsAppTemplateContent) o;
    return Objects.equals(this.templateName, whatsAppTemplateContent.templateName)
        && Objects.equals(this.templateData, whatsAppTemplateContent.templateData)
        && Objects.equals(this.language, whatsAppTemplateContent.language);
  }

  @Override
  public int hashCode() {
    return Objects.hash(templateName, templateData, language);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppTemplateContent {\n");
    sb.append("    templateName: ").append(toIndentedString(templateName)).append("\n");
    sb.append("    templateData: ").append(toIndentedString(templateData)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
