/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Objects;

/** WhatsAppTemplatePublicApiRequest */
public class WhatsAppTemplatePublicApiRequest {
  public static final String SERIALIZED_NAME_NAME = "name";

  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * The language code or locale to use. Multiple templates with different language codes can be
   * registered under the same template name.
   */
  @JsonAdapter(LanguageEnum.Adapter.class)
  public enum LanguageEnum {
    AF("af"),

    SQ("sq"),

    AR("ar"),

    AZ("az"),

    BN("bn"),

    BG("bg"),

    CA("ca"),

    ZH_CN("zh_CN"),

    ZH_HK("zh_HK"),

    ZH_TW("zh_TW"),

    HR("hr"),

    CS("cs"),

    DA("da"),

    NL("nl"),

    EN("en"),

    EN_GB("en_GB"),

    EN_US("en_US"),

    ET("et"),

    FIL("fil"),

    FI("fi"),

    FR("fr"),

    DE("de"),

    EL("el"),

    GU("gu"),

    HA("ha"),

    HE("he"),

    HI("hi"),

    HU("hu"),

    ID("id"),

    GA("ga"),

    IT("it"),

    JA("ja"),

    KN("kn"),

    KK("kk"),

    KO("ko"),

    LO("lo"),

    LV("lv"),

    LT("lt"),

    MK("mk"),

    MS("ms"),

    ML("ml"),

    MR("mr"),

    NB("nb"),

    FA("fa"),

    PL("pl"),

    PT_BR("pt_BR"),

    PT_PT("pt_PT"),

    PA("pa"),

    RO("ro"),

    RU("ru"),

    SR("sr"),

    SK("sk"),

    SL("sl"),

    ES("es"),

    ES_AR("es_AR"),

    ES_ES("es_ES"),

    ES_MX("es_MX"),

    SW("sw"),

    SV("sv"),

    TA("ta"),

    TE("te"),

    TH("th"),

    TR("tr"),

    UK("uk"),

    UR("ur"),

    UZ("uz"),

    VI("vi"),

    UNKNOWN("unknown");

    private String value;

    LanguageEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LanguageEnum fromValue(String value) {
      for (LanguageEnum b : LanguageEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<LanguageEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LanguageEnum enumeration)
          throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LanguageEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return LanguageEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_LANGUAGE = "language";

  @SerializedName(SERIALIZED_NAME_LANGUAGE)
  private LanguageEnum language;

  /** Category of the template. */
  @JsonAdapter(CategoryEnum.Adapter.class)
  public enum CategoryEnum {
    ACCOUNT_UPDATE("ACCOUNT_UPDATE"),

    PAYMENT_UPDATE("PAYMENT_UPDATE"),

    PERSONAL_FINANCE_UPDATE("PERSONAL_FINANCE_UPDATE"),

    SHIPPING_UPDATE("SHIPPING_UPDATE"),

    RESERVATION_UPDATE("RESERVATION_UPDATE"),

    ISSUE_RESOLUTION("ISSUE_RESOLUTION"),

    APPOINTMENT_UPDATE("APPOINTMENT_UPDATE"),

    TRANSPORTATION_UPDATE("TRANSPORTATION_UPDATE"),

    TICKET_UPDATE("TICKET_UPDATE"),

    ALERT_UPDATE("ALERT_UPDATE"),

    AUTO_REPLY("AUTO_REPLY");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CategoryEnum fromValue(String value) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CategoryEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CategoryEnum enumeration)
          throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CategoryEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return CategoryEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CATEGORY = "category";

  @SerializedName(SERIALIZED_NAME_CATEGORY)
  private CategoryEnum category;

  public static final String SERIALIZED_NAME_STRUCTURE = "structure";

  @SerializedName(SERIALIZED_NAME_STRUCTURE)
  private WhatsAppTemplateStructureApiData structure;

  public WhatsAppTemplatePublicApiRequest name(String name) {

    this.name = name;
    return this;
  }

  /**
   * Template name. Must only contain lowercase alphanumeric characters and underscores.
   *
   * @return name
   */
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WhatsAppTemplatePublicApiRequest language(LanguageEnum language) {

    this.language = language;
    return this;
  }

  /**
   * The language code or locale to use. Multiple templates with different language codes can be
   * registered under the same template name.
   *
   * @return language
   */
  public LanguageEnum getLanguage() {
    return language;
  }

  public void setLanguage(LanguageEnum language) {
    this.language = language;
  }

  public WhatsAppTemplatePublicApiRequest category(CategoryEnum category) {

    this.category = category;
    return this;
  }

  /**
   * Category of the template.
   *
   * @return category
   */
  public CategoryEnum getCategory() {
    return category;
  }

  public void setCategory(CategoryEnum category) {
    this.category = category;
  }

  public WhatsAppTemplatePublicApiRequest structure(WhatsAppTemplateStructureApiData structure) {

    this.structure = structure;
    return this;
  }

  /**
   * Get structure
   *
   * @return structure
   */
  public WhatsAppTemplateStructureApiData getStructure() {
    return structure;
  }

  public void setStructure(WhatsAppTemplateStructureApiData structure) {
    this.structure = structure;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest =
        (WhatsAppTemplatePublicApiRequest) o;
    return Objects.equals(this.name, whatsAppTemplatePublicApiRequest.name)
        && Objects.equals(this.language, whatsAppTemplatePublicApiRequest.language)
        && Objects.equals(this.category, whatsAppTemplatePublicApiRequest.category)
        && Objects.equals(this.structure, whatsAppTemplatePublicApiRequest.structure);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, language, category, structure);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppTemplatePublicApiRequest {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    structure: ").append(toIndentedString(structure)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
