/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/** Template structure. */
public class WhatsAppTemplateStructureApiData {
  public static final String SERIALIZED_NAME_HEADER = "header";

  @SerializedName(SERIALIZED_NAME_HEADER)
  private WhatsAppHeaderApiData header;

  public static final String SERIALIZED_NAME_BODY = "body";

  @SerializedName(SERIALIZED_NAME_BODY)
  private String body;

  public static final String SERIALIZED_NAME_FOOTER = "footer";

  @SerializedName(SERIALIZED_NAME_FOOTER)
  private String footer;

  public static final String SERIALIZED_NAME_BUTTONS = "buttons";

  @SerializedName(SERIALIZED_NAME_BUTTONS)
  private List<WhatsAppButtonApiData> buttons = null;

  /** Gets or Sets type */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    TEXT("TEXT"),

    MEDIA("MEDIA"),

    UNSUPPORTED("UNSUPPORTED");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration)
          throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";

  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public WhatsAppTemplateStructureApiData header(WhatsAppHeaderApiData header) {

    this.header = header;
    return this;
  }

  /**
   * Get header
   *
   * @return header
   */
  public WhatsAppHeaderApiData getHeader() {
    return header;
  }

  public void setHeader(WhatsAppHeaderApiData header) {
    this.header = header;
  }

  public WhatsAppTemplateStructureApiData body(String body) {

    this.body = body;
    return this;
  }

  /**
   * Template body. Can be registered as plain text or text with placeholders. Placeholders have to
   * be correctly formatted and in the correct order, regardless of other sections. Example: {{1}},
   * {{2}}, {{3}}...
   *
   * @return body
   */
  public String getBody() {
    return body;
  }

  public void setBody(String body) {
    this.body = body;
  }

  public WhatsAppTemplateStructureApiData footer(String footer) {

    this.footer = footer;
    return this;
  }

  /**
   * Template footer. Plain text, up to 60 characters.
   *
   * @return footer
   */
  public String getFooter() {
    return footer;
  }

  public void setFooter(String footer) {
    this.footer = footer;
  }

  public WhatsAppTemplateStructureApiData buttons(List<WhatsAppButtonApiData> buttons) {

    this.buttons = buttons;
    return this;
  }

  public WhatsAppTemplateStructureApiData addButtonsItem(WhatsAppButtonApiData buttonsItem) {
    if (this.buttons == null) {
      this.buttons = new ArrayList<>();
    }
    this.buttons.add(buttonsItem);
    return this;
  }

  /**
   * Template buttons. Can be either up to 3 &#x60;quick reply&#x60; buttons or up to 2 &#x60;call
   * to action&#x60; buttons. Call to action buttons must be unique in type.
   *
   * @return buttons
   */
  public List<WhatsAppButtonApiData> getButtons() {
    return buttons;
  }

  public void setButtons(List<WhatsAppButtonApiData> buttons) {
    this.buttons = buttons;
  }

  /**
   * Get type
   *
   * @return type
   */
  public TypeEnum getType() {
    return type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppTemplateStructureApiData whatsAppTemplateStructureApiData =
        (WhatsAppTemplateStructureApiData) o;
    return Objects.equals(this.header, whatsAppTemplateStructureApiData.header)
        && Objects.equals(this.body, whatsAppTemplateStructureApiData.body)
        && Objects.equals(this.footer, whatsAppTemplateStructureApiData.footer)
        && Objects.equals(this.buttons, whatsAppTemplateStructureApiData.buttons)
        && Objects.equals(this.type, whatsAppTemplateStructureApiData.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(header, body, footer, buttons, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppTemplateStructureApiData {\n");
    sb.append("    header: ").append(toIndentedString(header)).append("\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    footer: ").append(toIndentedString(footer)).append("\n");
    sb.append("    buttons: ").append(toIndentedString(buttons)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
