/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** The content object to build a message that will be sent. */
public class WhatsAppTextContent {
  public static final String SERIALIZED_NAME_TEXT = "text";

  @SerializedName(SERIALIZED_NAME_TEXT)
  private String text;

  public static final String SERIALIZED_NAME_PREVIEW_URL = "previewUrl";

  @SerializedName(SERIALIZED_NAME_PREVIEW_URL)
  private Boolean previewUrl;

  public WhatsAppTextContent text(String text) {

    this.text = text;
    return this;
  }

  /**
   * Content of the message being sent.
   *
   * @return text
   */
  public String getText() {
    return text;
  }

  public void setText(String text) {
    this.text = text;
  }

  public WhatsAppTextContent previewUrl(Boolean previewUrl) {

    this.previewUrl = previewUrl;
    return this;
  }

  /**
   * Allows for URL preview from within the message. If the value is set to &#x60;true&#x60;, the
   * message content is expected to contain a URL starting with &#x60;https://&#x60; or
   * &#x60;http://&#x60;. The default value is &#x60;false&#x60;.
   *
   * @return previewUrl
   */
  public Boolean getPreviewUrl() {
    return previewUrl;
  }

  public void setPreviewUrl(Boolean previewUrl) {
    this.previewUrl = previewUrl;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppTextContent whatsAppTextContent = (WhatsAppTextContent) o;
    return Objects.equals(this.text, whatsAppTextContent.text)
        && Objects.equals(this.previewUrl, whatsAppTextContent.previewUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(text, previewUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppTextContent {\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    previewUrl: ").append(toIndentedString(previewUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
