/*
 * Infobip Client API Libraries OpenAPI Specification
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.infobip.model;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;

/** WhatsAppUrlButtonApiData */
public class WhatsAppUrlButtonApiData extends WhatsAppButtonApiData {
  public static final String SERIALIZED_NAME_URL = "url";

  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public WhatsAppUrlButtonApiData url(String url) {

    this.url = url;
    return this;
  }

  /**
   * URL to which the end-user will be directed when hitting the button. URL is expected to start
   * with &#x60;https://&#x60; or &#x60;http://&#x60;. Can be static or dynamic. For dynamic URL
   * registration, add a placeholder {{1}} at the end of the link. Example:
   * &#x60;https://www.infobip.com/{{1}}&#x60;
   *
   * @return url
   */
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsAppUrlButtonApiData whatsAppUrlButtonApiData = (WhatsAppUrlButtonApiData) o;
    return Objects.equals(this.url, whatsAppUrlButtonApiData.url) && super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsAppUrlButtonApiData {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
