/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.google.gson.reflect.TypeToken;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.ApiResponse;
import com.infobip.Configuration;
import com.infobip.Pair;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ReceiveWhatsAppApi {
    private ApiClient localVarApiClient;

    public ReceiveWhatsAppApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReceiveWhatsAppApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call downloadWhatsAppInboundMediaCall(String sender, String mediaId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/1/senders/{sender}/media/{mediaId}".replaceAll("\\{sender\\}", this.localVarApiClient.escapeString(sender.toString())).replaceAll("\\{mediaId\\}", this.localVarApiClient.escapeString(mediaId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadWhatsAppInboundMediaValidateBeforeCall(String sender, String mediaId, ApiCallback _callback) throws ApiException {
        if (sender == null) {
            throw new ApiException("Missing the required parameter 'sender' when calling downloadWhatsAppInboundMedia(Async)");
        }
        if (mediaId == null) {
            throw new ApiException("Missing the required parameter 'mediaId' when calling downloadWhatsAppInboundMedia(Async)");
        }
        Call localVarCall = this.downloadWhatsAppInboundMediaCall(sender, mediaId, _callback);
        return localVarCall;
    }

    public File downloadWhatsAppInboundMedia(String sender, String mediaId) throws ApiException {
        ApiResponse<File> localVarResp = this.downloadWhatsAppInboundMediaWithHttpInfo(sender, mediaId);
        return localVarResp.getData();
    }

    public ApiResponse<File> downloadWhatsAppInboundMediaWithHttpInfo(String sender, String mediaId) throws ApiException {
        Call localVarCall = this.downloadWhatsAppInboundMediaValidateBeforeCall(sender, mediaId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadWhatsAppInboundMediaAsync(String sender, String mediaId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.downloadWhatsAppInboundMediaValidateBeforeCall(sender, mediaId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWhatsAppMediaMetadataCall(String sender, String mediaId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/1/senders/{sender}/media/{mediaId}".replaceAll("\\{sender\\}", this.localVarApiClient.escapeString(sender.toString())).replaceAll("\\{mediaId\\}", this.localVarApiClient.escapeString(mediaId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "HEAD", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWhatsAppMediaMetadataValidateBeforeCall(String sender, String mediaId, ApiCallback _callback) throws ApiException {
        if (sender == null) {
            throw new ApiException("Missing the required parameter 'sender' when calling getWhatsAppMediaMetadata(Async)");
        }
        if (mediaId == null) {
            throw new ApiException("Missing the required parameter 'mediaId' when calling getWhatsAppMediaMetadata(Async)");
        }
        Call localVarCall = this.getWhatsAppMediaMetadataCall(sender, mediaId, _callback);
        return localVarCall;
    }

    public String getWhatsAppMediaMetadata(String sender, String mediaId) throws ApiException {
        ApiResponse<String> localVarResp = this.getWhatsAppMediaMetadataWithHttpInfo(sender, mediaId);
        return localVarResp.getData();
    }

    public ApiResponse<String> getWhatsAppMediaMetadataWithHttpInfo(String sender, String mediaId) throws ApiException {
        Call localVarCall = this.getWhatsAppMediaMetadataValidateBeforeCall(sender, mediaId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWhatsAppMediaMetadataAsync(String sender, String mediaId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getWhatsAppMediaMetadataValidateBeforeCall(sender, mediaId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call markWhatsAppMessageAsReadCall(String sender, String messageId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/whatsapp/1/senders/{sender}/message/{messageId}/read".replaceAll("\\{sender\\}", this.localVarApiClient.escapeString(sender.toString())).replaceAll("\\{messageId\\}", this.localVarApiClient.escapeString(messageId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"APIKeyHeader", "Basic", "IBSSOTokenHeader", "OAuth2"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call markWhatsAppMessageAsReadValidateBeforeCall(String sender, String messageId, ApiCallback _callback) throws ApiException {
        if (sender == null) {
            throw new ApiException("Missing the required parameter 'sender' when calling markWhatsAppMessageAsRead(Async)");
        }
        if (messageId == null) {
            throw new ApiException("Missing the required parameter 'messageId' when calling markWhatsAppMessageAsRead(Async)");
        }
        Call localVarCall = this.markWhatsAppMessageAsReadCall(sender, messageId, _callback);
        return localVarCall;
    }

    public void markWhatsAppMessageAsRead(String sender, String messageId) throws ApiException {
        this.markWhatsAppMessageAsReadWithHttpInfo(sender, messageId);
    }

    public ApiResponse<Void> markWhatsAppMessageAsReadWithHttpInfo(String sender, String messageId) throws ApiException {
        Call localVarCall = this.markWhatsAppMessageAsReadValidateBeforeCall(sender, messageId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call markWhatsAppMessageAsReadAsync(String sender, String messageId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.markWhatsAppMessageAsReadValidateBeforeCall(sender, messageId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

