/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.SmsAdvancedBinaryRequest;
import com.infobip.model.SmsAdvancedTextualRequest;
import com.infobip.model.SmsBulkRequest;
import com.infobip.model.SmsBulkResponse;
import com.infobip.model.SmsBulkStatusResponse;
import com.infobip.model.SmsDeliveryResult;
import com.infobip.model.SmsInboundMessageResult;
import com.infobip.model.SmsLogsResponse;
import com.infobip.model.SmsPreviewRequest;
import com.infobip.model.SmsPreviewResponse;
import com.infobip.model.SmsResponse;
import com.infobip.model.SmsUpdateStatusRequest;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class SmsApi {
    private final ApiClient apiClient;

    public SmsApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition getInboundSmsMessagesDefinition(Integer limit) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/sms/1/inbox/reports").requiresAuthentication(true).accept("application/json");
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        return builder.build();
    }

    public GetInboundSmsMessagesRequest getInboundSmsMessages() {
        return new GetInboundSmsMessagesRequest();
    }

    private RequestDefinition getOutboundSmsMessageDeliveryReportsDefinition(String bulkId, String messageId, Integer limit) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/sms/1/reports").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        return builder.build();
    }

    public GetOutboundSmsMessageDeliveryReportsRequest getOutboundSmsMessageDeliveryReports() {
        return new GetOutboundSmsMessageDeliveryReportsRequest();
    }

    private RequestDefinition getOutboundSmsMessageLogsDefinition(String from, String to, List<String> bulkId, List<String> messageId, String generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, String mcc, String mnc) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/sms/1/logs").requiresAuthentication(true).accept("application/json");
        if (from != null) {
            builder.addQueryParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addQueryParameter(new Parameter("to", to));
        }
        if (bulkId != null) {
            for (String parameterItem : bulkId) {
                builder.addQueryParameter(new Parameter("bulkId", bulkId));
            }
        }
        if (messageId != null) {
            for (String parameterItem : messageId) {
                builder.addQueryParameter(new Parameter("messageId", messageId));
            }
        }
        if (generalStatus != null) {
            builder.addQueryParameter(new Parameter("generalStatus", generalStatus));
        }
        if (sentSince != null) {
            builder.addQueryParameter(new Parameter("sentSince", sentSince));
        }
        if (sentUntil != null) {
            builder.addQueryParameter(new Parameter("sentUntil", sentUntil));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (mcc != null) {
            builder.addQueryParameter(new Parameter("mcc", mcc));
        }
        if (mnc != null) {
            builder.addQueryParameter(new Parameter("mnc", mnc));
        }
        return builder.build();
    }

    public GetOutboundSmsMessageLogsRequest getOutboundSmsMessageLogs() {
        return new GetOutboundSmsMessageLogsRequest();
    }

    private RequestDefinition getScheduledSmsMessagesDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/sms/1/bulks").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetScheduledSmsMessagesRequest getScheduledSmsMessages(String bulkId) {
        return new GetScheduledSmsMessagesRequest(bulkId);
    }

    private RequestDefinition getScheduledSmsMessagesStatusDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/sms/1/bulks/status").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetScheduledSmsMessagesStatusRequest getScheduledSmsMessagesStatus(String bulkId) {
        return new GetScheduledSmsMessagesStatusRequest(bulkId);
    }

    private RequestDefinition previewSmsMessageDefinition(SmsPreviewRequest smsPreviewRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/sms/1/preview").body(smsPreviewRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public PreviewSmsMessageRequest previewSmsMessage(SmsPreviewRequest smsPreviewRequest) {
        return new PreviewSmsMessageRequest(smsPreviewRequest);
    }

    private RequestDefinition rescheduleSmsMessagesDefinition(String bulkId, SmsBulkRequest smsBulkRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/sms/1/bulks").body(smsBulkRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public RescheduleSmsMessagesRequest rescheduleSmsMessages(String bulkId, SmsBulkRequest smsBulkRequest) {
        return new RescheduleSmsMessagesRequest(bulkId, smsBulkRequest);
    }

    private RequestDefinition sendBinarySmsMessageDefinition(SmsAdvancedBinaryRequest smsAdvancedBinaryRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/sms/2/binary/advanced").body(smsAdvancedBinaryRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendBinarySmsMessageRequest sendBinarySmsMessage(SmsAdvancedBinaryRequest smsAdvancedBinaryRequest) {
        return new SendBinarySmsMessageRequest(smsAdvancedBinaryRequest);
    }

    private RequestDefinition sendSmsMessageDefinition(SmsAdvancedTextualRequest smsAdvancedTextualRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/sms/2/text/advanced").body(smsAdvancedTextualRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendSmsMessageRequest sendSmsMessage(SmsAdvancedTextualRequest smsAdvancedTextualRequest) {
        return new SendSmsMessageRequest(smsAdvancedTextualRequest);
    }

    private RequestDefinition updateScheduledSmsMessagesStatusDefinition(String bulkId, SmsUpdateStatusRequest smsUpdateStatusRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/sms/1/bulks/status").body(smsUpdateStatusRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public UpdateScheduledSmsMessagesStatusRequest updateScheduledSmsMessagesStatus(String bulkId, SmsUpdateStatusRequest smsUpdateStatusRequest) {
        return new UpdateScheduledSmsMessagesStatusRequest(bulkId, smsUpdateStatusRequest);
    }

    public class UpdateScheduledSmsMessagesStatusRequest {
        private final String bulkId;
        private final SmsUpdateStatusRequest smsUpdateStatusRequest;

        private UpdateScheduledSmsMessagesStatusRequest(String bulkId, SmsUpdateStatusRequest smsUpdateStatusRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.smsUpdateStatusRequest = Objects.requireNonNull(smsUpdateStatusRequest, "The required parameter 'smsUpdateStatusRequest' is missing.");
        }

        public SmsBulkStatusResponse execute() throws ApiException {
            RequestDefinition updateScheduledSmsMessagesStatusDefinition = SmsApi.this.updateScheduledSmsMessagesStatusDefinition(this.bulkId, this.smsUpdateStatusRequest);
            return (SmsBulkStatusResponse)SmsApi.this.apiClient.execute(updateScheduledSmsMessagesStatusDefinition, new TypeReference<SmsBulkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsBulkStatusResponse> callback) {
            RequestDefinition updateScheduledSmsMessagesStatusDefinition = SmsApi.this.updateScheduledSmsMessagesStatusDefinition(this.bulkId, this.smsUpdateStatusRequest);
            return SmsApi.this.apiClient.executeAsync(updateScheduledSmsMessagesStatusDefinition, new TypeReference<SmsBulkStatusResponse>(){}.getType(), callback);
        }
    }

    public class SendSmsMessageRequest {
        private final SmsAdvancedTextualRequest smsAdvancedTextualRequest;

        private SendSmsMessageRequest(SmsAdvancedTextualRequest smsAdvancedTextualRequest) {
            this.smsAdvancedTextualRequest = Objects.requireNonNull(smsAdvancedTextualRequest, "The required parameter 'smsAdvancedTextualRequest' is missing.");
        }

        public SmsResponse execute() throws ApiException {
            RequestDefinition sendSmsMessageDefinition = SmsApi.this.sendSmsMessageDefinition(this.smsAdvancedTextualRequest);
            return (SmsResponse)SmsApi.this.apiClient.execute(sendSmsMessageDefinition, new TypeReference<SmsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsResponse> callback) {
            RequestDefinition sendSmsMessageDefinition = SmsApi.this.sendSmsMessageDefinition(this.smsAdvancedTextualRequest);
            return SmsApi.this.apiClient.executeAsync(sendSmsMessageDefinition, new TypeReference<SmsResponse>(){}.getType(), callback);
        }
    }

    public class SendBinarySmsMessageRequest {
        private final SmsAdvancedBinaryRequest smsAdvancedBinaryRequest;

        private SendBinarySmsMessageRequest(SmsAdvancedBinaryRequest smsAdvancedBinaryRequest) {
            this.smsAdvancedBinaryRequest = Objects.requireNonNull(smsAdvancedBinaryRequest, "The required parameter 'smsAdvancedBinaryRequest' is missing.");
        }

        public SmsResponse execute() throws ApiException {
            RequestDefinition sendBinarySmsMessageDefinition = SmsApi.this.sendBinarySmsMessageDefinition(this.smsAdvancedBinaryRequest);
            return (SmsResponse)SmsApi.this.apiClient.execute(sendBinarySmsMessageDefinition, new TypeReference<SmsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsResponse> callback) {
            RequestDefinition sendBinarySmsMessageDefinition = SmsApi.this.sendBinarySmsMessageDefinition(this.smsAdvancedBinaryRequest);
            return SmsApi.this.apiClient.executeAsync(sendBinarySmsMessageDefinition, new TypeReference<SmsResponse>(){}.getType(), callback);
        }
    }

    public class RescheduleSmsMessagesRequest {
        private final String bulkId;
        private final SmsBulkRequest smsBulkRequest;

        private RescheduleSmsMessagesRequest(String bulkId, SmsBulkRequest smsBulkRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.smsBulkRequest = Objects.requireNonNull(smsBulkRequest, "The required parameter 'smsBulkRequest' is missing.");
        }

        public SmsBulkResponse execute() throws ApiException {
            RequestDefinition rescheduleSmsMessagesDefinition = SmsApi.this.rescheduleSmsMessagesDefinition(this.bulkId, this.smsBulkRequest);
            return (SmsBulkResponse)SmsApi.this.apiClient.execute(rescheduleSmsMessagesDefinition, new TypeReference<SmsBulkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsBulkResponse> callback) {
            RequestDefinition rescheduleSmsMessagesDefinition = SmsApi.this.rescheduleSmsMessagesDefinition(this.bulkId, this.smsBulkRequest);
            return SmsApi.this.apiClient.executeAsync(rescheduleSmsMessagesDefinition, new TypeReference<SmsBulkResponse>(){}.getType(), callback);
        }
    }

    public class PreviewSmsMessageRequest {
        private final SmsPreviewRequest smsPreviewRequest;

        private PreviewSmsMessageRequest(SmsPreviewRequest smsPreviewRequest) {
            this.smsPreviewRequest = Objects.requireNonNull(smsPreviewRequest, "The required parameter 'smsPreviewRequest' is missing.");
        }

        public SmsPreviewResponse execute() throws ApiException {
            RequestDefinition previewSmsMessageDefinition = SmsApi.this.previewSmsMessageDefinition(this.smsPreviewRequest);
            return (SmsPreviewResponse)SmsApi.this.apiClient.execute(previewSmsMessageDefinition, new TypeReference<SmsPreviewResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsPreviewResponse> callback) {
            RequestDefinition previewSmsMessageDefinition = SmsApi.this.previewSmsMessageDefinition(this.smsPreviewRequest);
            return SmsApi.this.apiClient.executeAsync(previewSmsMessageDefinition, new TypeReference<SmsPreviewResponse>(){}.getType(), callback);
        }
    }

    public class GetScheduledSmsMessagesStatusRequest {
        private final String bulkId;

        private GetScheduledSmsMessagesStatusRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public SmsBulkStatusResponse execute() throws ApiException {
            RequestDefinition getScheduledSmsMessagesStatusDefinition = SmsApi.this.getScheduledSmsMessagesStatusDefinition(this.bulkId);
            return (SmsBulkStatusResponse)SmsApi.this.apiClient.execute(getScheduledSmsMessagesStatusDefinition, new TypeReference<SmsBulkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsBulkStatusResponse> callback) {
            RequestDefinition getScheduledSmsMessagesStatusDefinition = SmsApi.this.getScheduledSmsMessagesStatusDefinition(this.bulkId);
            return SmsApi.this.apiClient.executeAsync(getScheduledSmsMessagesStatusDefinition, new TypeReference<SmsBulkStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetScheduledSmsMessagesRequest {
        private final String bulkId;

        private GetScheduledSmsMessagesRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public SmsBulkResponse execute() throws ApiException {
            RequestDefinition getScheduledSmsMessagesDefinition = SmsApi.this.getScheduledSmsMessagesDefinition(this.bulkId);
            return (SmsBulkResponse)SmsApi.this.apiClient.execute(getScheduledSmsMessagesDefinition, new TypeReference<SmsBulkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsBulkResponse> callback) {
            RequestDefinition getScheduledSmsMessagesDefinition = SmsApi.this.getScheduledSmsMessagesDefinition(this.bulkId);
            return SmsApi.this.apiClient.executeAsync(getScheduledSmsMessagesDefinition, new TypeReference<SmsBulkResponse>(){}.getType(), callback);
        }
    }

    public class GetOutboundSmsMessageLogsRequest {
        private String from;
        private String to;
        private List<String> bulkId;
        private List<String> messageId;
        private String generalStatus;
        private OffsetDateTime sentSince;
        private OffsetDateTime sentUntil;
        private Integer limit;
        private String mcc;
        private String mnc;

        private GetOutboundSmsMessageLogsRequest() {
        }

        public GetOutboundSmsMessageLogsRequest from(String from) {
            this.from = from;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest to(String to) {
            this.to = to;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest bulkId(List<String> bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest messageId(List<String> messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest generalStatus(String generalStatus) {
            this.generalStatus = generalStatus;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest sentSince(OffsetDateTime sentSince) {
            this.sentSince = sentSince;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest sentUntil(OffsetDateTime sentUntil) {
            this.sentUntil = sentUntil;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest mcc(String mcc) {
            this.mcc = mcc;
            return this;
        }

        public GetOutboundSmsMessageLogsRequest mnc(String mnc) {
            this.mnc = mnc;
            return this;
        }

        public SmsLogsResponse execute() throws ApiException {
            RequestDefinition getOutboundSmsMessageLogsDefinition = SmsApi.this.getOutboundSmsMessageLogsDefinition(this.from, this.to, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.mcc, this.mnc);
            return (SmsLogsResponse)SmsApi.this.apiClient.execute(getOutboundSmsMessageLogsDefinition, new TypeReference<SmsLogsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsLogsResponse> callback) {
            RequestDefinition getOutboundSmsMessageLogsDefinition = SmsApi.this.getOutboundSmsMessageLogsDefinition(this.from, this.to, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.mcc, this.mnc);
            return SmsApi.this.apiClient.executeAsync(getOutboundSmsMessageLogsDefinition, new TypeReference<SmsLogsResponse>(){}.getType(), callback);
        }
    }

    public class GetOutboundSmsMessageDeliveryReportsRequest {
        private String bulkId;
        private String messageId;
        private Integer limit;

        private GetOutboundSmsMessageDeliveryReportsRequest() {
        }

        public GetOutboundSmsMessageDeliveryReportsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundSmsMessageDeliveryReportsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundSmsMessageDeliveryReportsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public SmsDeliveryResult execute() throws ApiException {
            RequestDefinition getOutboundSmsMessageDeliveryReportsDefinition = SmsApi.this.getOutboundSmsMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit);
            return (SmsDeliveryResult)SmsApi.this.apiClient.execute(getOutboundSmsMessageDeliveryReportsDefinition, new TypeReference<SmsDeliveryResult>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsDeliveryResult> callback) {
            RequestDefinition getOutboundSmsMessageDeliveryReportsDefinition = SmsApi.this.getOutboundSmsMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit);
            return SmsApi.this.apiClient.executeAsync(getOutboundSmsMessageDeliveryReportsDefinition, new TypeReference<SmsDeliveryResult>(){}.getType(), callback);
        }
    }

    public class GetInboundSmsMessagesRequest {
        private Integer limit;

        private GetInboundSmsMessagesRequest() {
        }

        public GetInboundSmsMessagesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public SmsInboundMessageResult execute() throws ApiException {
            RequestDefinition getInboundSmsMessagesDefinition = SmsApi.this.getInboundSmsMessagesDefinition(this.limit);
            return (SmsInboundMessageResult)SmsApi.this.apiClient.execute(getInboundSmsMessagesDefinition, new TypeReference<SmsInboundMessageResult>(){}.getType());
        }

        public Call executeAsync(ApiCallback<SmsInboundMessageResult> callback) {
            RequestDefinition getInboundSmsMessagesDefinition = SmsApi.this.getInboundSmsMessagesDefinition(this.limit);
            return SmsApi.this.apiClient.executeAsync(getInboundSmsMessagesDefinition, new TypeReference<SmsInboundMessageResult>(){}.getType(), callback);
        }
    }
}

