/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.RequestDefinition;
import com.infobip.model.ViberBulkMessageInfo;
import com.infobip.model.ViberBulkTextMessage;
import com.infobip.model.ViberFileMessage;
import com.infobip.model.ViberImageMessage;
import com.infobip.model.ViberSingleMessageInfo;
import com.infobip.model.ViberVideoMessage;
import java.util.Objects;
import okhttp3.Call;

public class ViberApi {
    private final ApiClient apiClient;

    public ViberApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition sendViberFileMessageDefinition(ViberFileMessage viberFileMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/1/message/file").body(viberFileMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendViberFileMessageRequest sendViberFileMessage(ViberFileMessage viberFileMessage) {
        return new SendViberFileMessageRequest(viberFileMessage);
    }

    private RequestDefinition sendViberImageMessageDefinition(ViberImageMessage viberImageMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/1/message/image").body(viberImageMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendViberImageMessageRequest sendViberImageMessage(ViberImageMessage viberImageMessage) {
        return new SendViberImageMessageRequest(viberImageMessage);
    }

    private RequestDefinition sendViberTextMessageDefinition(ViberBulkTextMessage viberBulkTextMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/1/message/text").body(viberBulkTextMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendViberTextMessageRequest sendViberTextMessage(ViberBulkTextMessage viberBulkTextMessage) {
        return new SendViberTextMessageRequest(viberBulkTextMessage);
    }

    private RequestDefinition sendViberVideoMessageDefinition(ViberVideoMessage viberVideoMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/1/message/video").body(viberVideoMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendViberVideoMessageRequest sendViberVideoMessage(ViberVideoMessage viberVideoMessage) {
        return new SendViberVideoMessageRequest(viberVideoMessage);
    }

    public class SendViberVideoMessageRequest {
        private final ViberVideoMessage viberVideoMessage;

        private SendViberVideoMessageRequest(ViberVideoMessage viberVideoMessage) {
            this.viberVideoMessage = Objects.requireNonNull(viberVideoMessage, "The required parameter 'viberVideoMessage' is missing.");
        }

        public ViberSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendViberVideoMessageDefinition = ViberApi.this.sendViberVideoMessageDefinition(this.viberVideoMessage);
            return (ViberSingleMessageInfo)ViberApi.this.apiClient.execute(sendViberVideoMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberSingleMessageInfo> callback) {
            RequestDefinition sendViberVideoMessageDefinition = ViberApi.this.sendViberVideoMessageDefinition(this.viberVideoMessage);
            return ViberApi.this.apiClient.executeAsync(sendViberVideoMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendViberTextMessageRequest {
        private final ViberBulkTextMessage viberBulkTextMessage;

        private SendViberTextMessageRequest(ViberBulkTextMessage viberBulkTextMessage) {
            this.viberBulkTextMessage = Objects.requireNonNull(viberBulkTextMessage, "The required parameter 'viberBulkTextMessage' is missing.");
        }

        public ViberBulkMessageInfo execute() throws ApiException {
            RequestDefinition sendViberTextMessageDefinition = ViberApi.this.sendViberTextMessageDefinition(this.viberBulkTextMessage);
            return (ViberBulkMessageInfo)ViberApi.this.apiClient.execute(sendViberTextMessageDefinition, new TypeReference<ViberBulkMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberBulkMessageInfo> callback) {
            RequestDefinition sendViberTextMessageDefinition = ViberApi.this.sendViberTextMessageDefinition(this.viberBulkTextMessage);
            return ViberApi.this.apiClient.executeAsync(sendViberTextMessageDefinition, new TypeReference<ViberBulkMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendViberImageMessageRequest {
        private final ViberImageMessage viberImageMessage;

        private SendViberImageMessageRequest(ViberImageMessage viberImageMessage) {
            this.viberImageMessage = Objects.requireNonNull(viberImageMessage, "The required parameter 'viberImageMessage' is missing.");
        }

        public ViberSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendViberImageMessageDefinition = ViberApi.this.sendViberImageMessageDefinition(this.viberImageMessage);
            return (ViberSingleMessageInfo)ViberApi.this.apiClient.execute(sendViberImageMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberSingleMessageInfo> callback) {
            RequestDefinition sendViberImageMessageDefinition = ViberApi.this.sendViberImageMessageDefinition(this.viberImageMessage);
            return ViberApi.this.apiClient.executeAsync(sendViberImageMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendViberFileMessageRequest {
        private final ViberFileMessage viberFileMessage;

        private SendViberFileMessageRequest(ViberFileMessage viberFileMessage) {
            this.viberFileMessage = Objects.requireNonNull(viberFileMessage, "The required parameter 'viberFileMessage' is missing.");
        }

        public ViberSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendViberFileMessageDefinition = ViberApi.this.sendViberFileMessageDefinition(this.viberFileMessage);
            return (ViberSingleMessageInfo)ViberApi.this.apiClient.execute(sendViberFileMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberSingleMessageInfo> callback) {
            RequestDefinition sendViberFileMessageDefinition = ViberApi.this.sendViberFileMessageDefinition(this.viberFileMessage);
            return ViberApi.this.apiClient.executeAsync(sendViberFileMessageDefinition, new TypeReference<ViberSingleMessageInfo>(){}.getType(), callback);
        }
    }
}

