/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infobip.model.CallDirection;
import com.infobip.model.CallEndpoint;
import com.infobip.model.CallState;
import com.infobip.model.CallsErrorCodeInfo;
import com.infobip.model.CallsMachineDetectionProperties;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CallLog {
    private String callId;
    private CallEndpoint endpoint;
    private String from;
    private String to;
    private CallDirection direction;
    private CallState state;
    private OffsetDateTime startTime;
    private OffsetDateTime answerTime;
    private OffsetDateTime endTime;
    private String parentCallId;
    private CallsMachineDetectionProperties machineDetection;
    private Long ringDuration;
    private List<String> applicationIds = null;
    private List<String> conferenceIds = null;
    private Long duration;
    private Boolean hasCameraVideo;
    private Boolean hasScreenshareVideo;
    private CallsErrorCodeInfo errorCode;
    private Map<String, String> customData = null;
    private String dialogId;

    public CallLog callId(String callId) {
        this.callId = callId;
        return this;
    }

    @JsonProperty(value="callId")
    public String getCallId() {
        return this.callId;
    }

    @JsonProperty(value="callId")
    public void setCallId(String callId) {
        this.callId = callId;
    }

    public CallLog endpoint(CallEndpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonProperty(value="endpoint")
    public CallEndpoint getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    public void setEndpoint(CallEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public CallLog from(String from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    public CallLog to(String to) {
        this.to = to;
        return this;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    public CallLog direction(CallDirection direction) {
        this.direction = direction;
        return this;
    }

    @JsonProperty(value="direction")
    public CallDirection getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    public void setDirection(CallDirection direction) {
        this.direction = direction;
    }

    public CallLog state(CallState state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    public CallState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(CallState state) {
        this.state = state;
    }

    public CallLog startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty(value="startTime")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public CallLog answerTime(OffsetDateTime answerTime) {
        this.answerTime = answerTime;
        return this;
    }

    @JsonProperty(value="answerTime")
    public OffsetDateTime getAnswerTime() {
        return this.answerTime;
    }

    @JsonProperty(value="answerTime")
    public void setAnswerTime(OffsetDateTime answerTime) {
        this.answerTime = answerTime;
    }

    public CallLog endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty(value="endTime")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public CallLog parentCallId(String parentCallId) {
        this.parentCallId = parentCallId;
        return this;
    }

    @JsonProperty(value="parentCallId")
    public String getParentCallId() {
        return this.parentCallId;
    }

    @JsonProperty(value="parentCallId")
    public void setParentCallId(String parentCallId) {
        this.parentCallId = parentCallId;
    }

    public CallLog machineDetection(CallsMachineDetectionProperties machineDetection) {
        this.machineDetection = machineDetection;
        return this;
    }

    @JsonProperty(value="machineDetection")
    public CallsMachineDetectionProperties getMachineDetection() {
        return this.machineDetection;
    }

    @JsonProperty(value="machineDetection")
    public void setMachineDetection(CallsMachineDetectionProperties machineDetection) {
        this.machineDetection = machineDetection;
    }

    public CallLog ringDuration(Long ringDuration) {
        this.ringDuration = ringDuration;
        return this;
    }

    @JsonProperty(value="ringDuration")
    public Long getRingDuration() {
        return this.ringDuration;
    }

    @JsonProperty(value="ringDuration")
    public void setRingDuration(Long ringDuration) {
        this.ringDuration = ringDuration;
    }

    public CallLog applicationIds(List<String> applicationIds) {
        this.applicationIds = applicationIds;
        return this;
    }

    public CallLog addApplicationIdsItem(String applicationIdsItem) {
        if (this.applicationIds == null) {
            this.applicationIds = new ArrayList<String>();
        }
        this.applicationIds.add(applicationIdsItem);
        return this;
    }

    @JsonProperty(value="applicationIds")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @JsonProperty(value="applicationIds")
    public void setApplicationIds(List<String> applicationIds) {
        this.applicationIds = applicationIds;
    }

    public CallLog conferenceIds(List<String> conferenceIds) {
        this.conferenceIds = conferenceIds;
        return this;
    }

    public CallLog addConferenceIdsItem(String conferenceIdsItem) {
        if (this.conferenceIds == null) {
            this.conferenceIds = new ArrayList<String>();
        }
        this.conferenceIds.add(conferenceIdsItem);
        return this;
    }

    @JsonProperty(value="conferenceIds")
    public List<String> getConferenceIds() {
        return this.conferenceIds;
    }

    @JsonProperty(value="conferenceIds")
    public void setConferenceIds(List<String> conferenceIds) {
        this.conferenceIds = conferenceIds;
    }

    public CallLog duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty(value="duration")
    public Long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public CallLog hasCameraVideo(Boolean hasCameraVideo) {
        this.hasCameraVideo = hasCameraVideo;
        return this;
    }

    @JsonProperty(value="hasCameraVideo")
    public Boolean getHasCameraVideo() {
        return this.hasCameraVideo;
    }

    @JsonProperty(value="hasCameraVideo")
    public void setHasCameraVideo(Boolean hasCameraVideo) {
        this.hasCameraVideo = hasCameraVideo;
    }

    public CallLog hasScreenshareVideo(Boolean hasScreenshareVideo) {
        this.hasScreenshareVideo = hasScreenshareVideo;
        return this;
    }

    @JsonProperty(value="hasScreenshareVideo")
    public Boolean getHasScreenshareVideo() {
        return this.hasScreenshareVideo;
    }

    @JsonProperty(value="hasScreenshareVideo")
    public void setHasScreenshareVideo(Boolean hasScreenshareVideo) {
        this.hasScreenshareVideo = hasScreenshareVideo;
    }

    public CallLog errorCode(CallsErrorCodeInfo errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @JsonProperty(value="errorCode")
    public CallsErrorCodeInfo getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty(value="errorCode")
    public void setErrorCode(CallsErrorCodeInfo errorCode) {
        this.errorCode = errorCode;
    }

    public CallLog customData(Map<String, String> customData) {
        this.customData = customData;
        return this;
    }

    public CallLog putCustomDataItem(String key, String customDataItem) {
        if (this.customData == null) {
            this.customData = new HashMap<String, String>();
        }
        this.customData.put(key, customDataItem);
        return this;
    }

    @JsonProperty(value="customData")
    public Map<String, String> getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(Map<String, String> customData) {
        this.customData = customData;
    }

    public CallLog dialogId(String dialogId) {
        this.dialogId = dialogId;
        return this;
    }

    @JsonProperty(value="dialogId")
    public String getDialogId() {
        return this.dialogId;
    }

    @JsonProperty(value="dialogId")
    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallLog callLog = (CallLog)o;
        return Objects.equals(this.callId, callLog.callId) && Objects.equals(this.endpoint, callLog.endpoint) && Objects.equals(this.from, callLog.from) && Objects.equals(this.to, callLog.to) && Objects.equals((Object)this.direction, (Object)callLog.direction) && Objects.equals((Object)this.state, (Object)callLog.state) && Objects.equals(this.startTime, callLog.startTime) && Objects.equals(this.answerTime, callLog.answerTime) && Objects.equals(this.endTime, callLog.endTime) && Objects.equals(this.parentCallId, callLog.parentCallId) && Objects.equals(this.machineDetection, callLog.machineDetection) && Objects.equals(this.ringDuration, callLog.ringDuration) && Objects.equals(this.applicationIds, callLog.applicationIds) && Objects.equals(this.conferenceIds, callLog.conferenceIds) && Objects.equals(this.duration, callLog.duration) && Objects.equals(this.hasCameraVideo, callLog.hasCameraVideo) && Objects.equals(this.hasScreenshareVideo, callLog.hasScreenshareVideo) && Objects.equals(this.errorCode, callLog.errorCode) && Objects.equals(this.customData, callLog.customData) && Objects.equals(this.dialogId, callLog.dialogId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.callId, this.endpoint, this.from, this.to, this.direction, this.state, this.startTime, this.answerTime, this.endTime, this.parentCallId, this.machineDetection, this.ringDuration, this.applicationIds, this.conferenceIds, this.duration, this.hasCameraVideo, this.hasScreenshareVideo, this.errorCode, this.customData, this.dialogId});
    }

    public String toString() {
        String newLine = System.lineSeparator();
        return "class CallLog {" + newLine + "    callId: " + this.toIndentedString(this.callId) + newLine + "    endpoint: " + this.toIndentedString(this.endpoint) + newLine + "    from: " + this.toIndentedString(this.from) + newLine + "    to: " + this.toIndentedString(this.to) + newLine + "    direction: " + this.toIndentedString((Object)this.direction) + newLine + "    state: " + this.toIndentedString((Object)this.state) + newLine + "    startTime: " + this.toIndentedString(this.startTime) + newLine + "    answerTime: " + this.toIndentedString(this.answerTime) + newLine + "    endTime: " + this.toIndentedString(this.endTime) + newLine + "    parentCallId: " + this.toIndentedString(this.parentCallId) + newLine + "    machineDetection: " + this.toIndentedString(this.machineDetection) + newLine + "    ringDuration: " + this.toIndentedString(this.ringDuration) + newLine + "    applicationIds: " + this.toIndentedString(this.applicationIds) + newLine + "    conferenceIds: " + this.toIndentedString(this.conferenceIds) + newLine + "    duration: " + this.toIndentedString(this.duration) + newLine + "    hasCameraVideo: " + this.toIndentedString(this.hasCameraVideo) + newLine + "    hasScreenshareVideo: " + this.toIndentedString(this.hasScreenshareVideo) + newLine + "    errorCode: " + this.toIndentedString(this.errorCode) + newLine + "    customData: " + this.toIndentedString(this.customData) + newLine + "    dialogId: " + this.toIndentedString(this.dialogId) + newLine + "}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        String lineSeparator = System.lineSeparator();
        String lineSeparatorFollowedByIndentation = lineSeparator + "    ";
        return o.toString().replace(lineSeparator, lineSeparatorFollowedByIndentation);
    }
}

