/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import com.infobip.ApiExceptionDetails;
import java.util.ArrayList;
import java.util.Map;

final class ApiExceptionDetailsResolver {
    private static final Map<String, String> errorCodes = Map.of("BAD_REQUEST", "E400", "UNAUTHORIZED", "E401", "NOT_FOUND", "E404", "TOO_MANY_REQUESTS", "E429", "GENERAL_ERROR", "E500");

    ApiExceptionDetailsResolver() {
    }

    ApiExceptionDetails resolveDetails(ApiExceptionDetails apiExceptionDetails) {
        if (apiExceptionDetails != null) {
            ApiExceptionDetails newApiExceptionDetails = new ApiExceptionDetails();
            newApiExceptionDetails.setMessageId(apiExceptionDetails.getMessageId());
            newApiExceptionDetails.setText(apiExceptionDetails.getText());
            newApiExceptionDetails.setValidationErrors(apiExceptionDetails.getValidationErrors());
            this.mapMessageIdToErrorCode(apiExceptionDetails, newApiExceptionDetails);
            this.mapTextToDescription(apiExceptionDetails, newApiExceptionDetails);
            newApiExceptionDetails.setAction(apiExceptionDetails.getAction());
            this.mapValidationErrorsToViolations(apiExceptionDetails, newApiExceptionDetails);
            newApiExceptionDetails.setResources(apiExceptionDetails.getResources());
            return newApiExceptionDetails;
        }
        return null;
    }

    private void mapValidationErrorsToViolations(ApiExceptionDetails apiExceptionDetails, ApiExceptionDetails newApiExceptionDetails) {
        if (apiExceptionDetails.getValidationErrors() != null) {
            ArrayList<ApiExceptionDetails.Violation> violations = new ArrayList<ApiExceptionDetails.Violation>();
            apiExceptionDetails.getValidationErrors().forEach((k, v) -> v.forEach(e -> {
                ApiExceptionDetails.Violation apiExceptionViolation = new ApiExceptionDetails.Violation();
                apiExceptionViolation.setProperty((String)k);
                apiExceptionViolation.setViolation((String)e);
                violations.add(apiExceptionViolation);
            }));
            newApiExceptionDetails.setViolations(violations);
        } else {
            newApiExceptionDetails.setViolations(apiExceptionDetails.getViolations());
        }
    }

    private void mapTextToDescription(ApiExceptionDetails apiExceptionDetails, ApiExceptionDetails newApiExceptionDetails) {
        if (apiExceptionDetails.getText() != null) {
            newApiExceptionDetails.setDescription(apiExceptionDetails.getText());
        } else {
            newApiExceptionDetails.setDescription(apiExceptionDetails.getDescription());
        }
    }

    private void mapMessageIdToErrorCode(ApiExceptionDetails apiExceptionDetails, ApiExceptionDetails newApiExceptionDetails) {
        if (apiExceptionDetails.getMessageId() != null) {
            newApiExceptionDetails.setErrorCode(errorCodes.get(apiExceptionDetails.getMessageId()));
        } else {
            newApiExceptionDetails.setErrorCode(apiExceptionDetails.getErrorCode());
        }
    }
}

