/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import com.infobip.ApiKey;
import com.infobip.BaseUrl;
import com.infobip.InternalException;
import com.infobip.JSON;
import com.infobip.JSONException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

final class RequestFactory {
    private static final String USER_AGENT_HEADER_VALUE = "infobip-api-client-java/4.1.1";
    private final ApiKey apiKey;
    private final BaseUrl baseUrl;
    private final JSON json;

    RequestFactory(ApiKey apiKey, BaseUrl baseUrl, JSON json) {
        this.apiKey = Objects.requireNonNull(apiKey);
        this.baseUrl = Objects.requireNonNull(baseUrl);
        this.json = Objects.requireNonNull(json);
    }

    ApiKey apiKey() {
        return this.apiKey;
    }

    BaseUrl baseUrl() {
        return this.baseUrl;
    }

    JSON json() {
        return this.json;
    }

    Request create(RequestDefinition definition) {
        Objects.requireNonNull(definition);
        return new Request.Builder().url(this.buildUrl(definition)).headers(this.buildHeaders(definition)).method(definition.method(), this.buildRequestBody(definition)).build();
    }

    private HttpUrl buildUrl(RequestDefinition definition) {
        String path = definition.path();
        for (Parameter param2 : definition.pathParameters()) {
            path = path.replaceAll("\\{" + param2.name() + "}", this.asUrlEncodedString(param2.value()));
        }
        URL apiUrl = this.baseUrl.getUrl();
        HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder().scheme(apiUrl.getProtocol()).host(apiUrl.getHost()).encodedPath(path);
        if (apiUrl.getPort() != -1) {
            httpUrlBuilder.port(apiUrl.getPort());
        }
        definition.queryParameters().forEach(param -> httpUrlBuilder.addEncodedQueryParameter(RequestFactory.urlEncode(param.name()), this.asUrlEncodedString(param.value())));
        return httpUrlBuilder.build();
    }

    private Headers buildHeaders(RequestDefinition definition) {
        Headers.Builder headersBuilder = new Headers.Builder();
        definition.headerParameters().forEach(param -> headersBuilder.set(param.name(), this.asString(param.value())));
        if (definition.requiresAuthentication()) {
            headersBuilder.set("Authorization", this.apiKey.getAuthorizationHeaderValue());
        }
        headersBuilder.set("User-Agent", USER_AGENT_HEADER_VALUE);
        definition.accept().ifPresent(accept -> headersBuilder.set("Accept", accept));
        definition.contentType().ifPresent(contentType -> headersBuilder.set("Content-Type", contentType));
        return headersBuilder.build();
    }

    private RequestBody buildRequestBody(RequestDefinition definition) {
        MediaType requestMediaType = definition.contentType().map(MediaTypeRegistry::parse).orElse(MediaTypeRegistry.JSON);
        if (MediaTypeRegistry.FORM.equals((Object)requestMediaType)) {
            return this.buildRequestBodyFormEncoding(definition.formParameters());
        }
        if (MediaTypeRegistry.MULTIPART.equals((Object)requestMediaType)) {
            return this.buildRequestBodyMultipart(definition.formParameters());
        }
        if (definition.body().isEmpty()) {
            if (HttpMethod.requiresRequestBody((String)definition.method())) {
                return RequestBody.create((String)"", (MediaType)requestMediaType);
            }
            return null;
        }
        if (!HttpMethod.permitsRequestBody((String)definition.method())) {
            throw InternalException.becauseBodyWasDefinedForMethodThatDoesNotPermitIt();
        }
        Object bodyRepresentation = definition.body().get();
        if (bodyRepresentation instanceof byte[]) {
            return RequestBody.create((byte[])((byte[])bodyRepresentation), (MediaType)MediaTypeRegistry.OCTET_STREAM);
        }
        if (bodyRepresentation instanceof File) {
            File file = (File)bodyRepresentation;
            return RequestBody.create((File)file, (MediaType)this.guessMediaType(file));
        }
        if (MediaTypeRegistry.JSON.equals((Object)requestMediaType)) {
            try {
                return RequestBody.create((String)this.json.serialize(bodyRepresentation), (MediaType)requestMediaType);
            }
            catch (JSONException jsonException) {
                throw InternalException.becauseRequestBodySerializationFailed(jsonException);
            }
        }
        throw InternalException.becauseRequestBodyCanNotBeProcessed();
    }

    private RequestBody buildRequestBodyFormEncoding(List<Parameter> formParams) {
        FormBody.Builder formBuilder = new FormBody.Builder();
        formParams.forEach(param -> formBuilder.add(param.name(), this.asString(param.value())));
        return formBuilder.build();
    }

    private RequestBody buildRequestBodyMultipart(List<Parameter> formParams) {
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        formParams.stream().flatMap(param -> {
            if (param.value() instanceof Collection) {
                return ((Collection)param.value()).stream().map(paramValue -> new Parameter(param.name(), paramValue));
            }
            return Stream.of(param);
        }).forEach(param -> {
            if (param.value() instanceof File) {
                File file = (File)param.value();
                MediaType mediaType = this.guessMediaType(file);
                multipartBuilder.addFormDataPart(param.name(), file.getName(), RequestBody.create((File)file, (MediaType)mediaType));
            } else {
                multipartBuilder.addFormDataPart(param.name(), this.asString(param.value()));
            }
        });
        return multipartBuilder.build();
    }

    private MediaType guessMediaType(File file) {
        return Optional.of(file.getName()).map(URLConnection::guessContentTypeFromName).map(MediaTypeRegistry::parse).orElse(MediaTypeRegistry.OCTET_STREAM);
    }

    private static String urlEncode(String string) {
        return URLEncoder.encode(string, StandardCharsets.UTF_8).replace("+", "%20");
    }

    private String asString(Object parameter) {
        if (parameter instanceof Collection) {
            return ((Collection)parameter).stream().map(param -> this.singularStringRepresentation(param, false)).collect(Collectors.joining(","));
        }
        return this.singularStringRepresentation(parameter, false);
    }

    private String asUrlEncodedString(Object parameter) {
        if (parameter instanceof Collection) {
            return ((Collection)parameter).stream().map(param -> this.singularStringRepresentation(param, true)).collect(Collectors.joining(","));
        }
        return this.singularStringRepresentation(parameter, true);
    }

    private String singularStringRepresentation(Object parameter, boolean encode) {
        if (parameter == null) {
            return "";
        }
        String stringRepresentation = parameter instanceof OffsetDateTime ? this.json.dateTimeFormatter().format((OffsetDateTime)parameter) : parameter.toString();
        return encode ? RequestFactory.urlEncode(stringRepresentation) : stringRepresentation;
    }

    private static final class MediaTypeRegistry {
        private static final MediaType JSON = MediaType.get((String)"application/json");
        private static final MediaType OCTET_STREAM = MediaType.get((String)"application/octet-stream");
        private static final MediaType MULTIPART = MediaType.get((String)"multipart/form-data");
        private static final MediaType FORM = MediaType.get((String)"application/x-www-form-urlencoded");
        private static final Map<String, MediaType> COMMON_EXPECTED_TYPES = Map.of("application/json", JSON, "application/octet-stream", OCTET_STREAM, "multipart/form-data", MULTIPART, "application/x-www-form-urlencoded", FORM);

        private MediaTypeRegistry() {
        }

        static MediaType parse(String mediaType) {
            MediaType commonType = COMMON_EXPECTED_TYPES.get(mediaType);
            if (commonType != null) {
                return commonType;
            }
            return MediaType.parse((String)mediaType);
        }
    }
}

