/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.WebRtcFilePageResponse;
import com.infobip.model.WebRtcFileResponse;
import com.infobip.model.WebRtcPushConfigurationPageResponse;
import com.infobip.model.WebRtcPushConfigurationRequest;
import com.infobip.model.WebRtcPushConfigurationResponse;
import com.infobip.model.WebRtcTokenRequestModel;
import com.infobip.model.WebRtcTokenResponseModel;
import java.io.File;
import java.util.Objects;
import okhttp3.Call;

public class WebRtcApi {
    private final ApiClient apiClient;

    public WebRtcApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition deleteFileDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/webrtc/1/files/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DeleteFileRequest deleteFile(String id) {
        return new DeleteFileRequest(id);
    }

    private RequestDefinition deletePushConfigurationDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/webrtc/1/webrtc-push-config/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DeletePushConfigurationRequest deletePushConfiguration(String id) {
        return new DeletePushConfigurationRequest(id);
    }

    private RequestDefinition downloadFileDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/webrtc/1/files/{id}/download").requiresAuthentication(true).accept("application/octet-stream");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DownloadFileRequest downloadFile(String id) {
        return new DownloadFileRequest(id);
    }

    private RequestDefinition generateWebRtcTokenDefinition(WebRtcTokenRequestModel webRtcTokenRequestModel) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/webrtc/1/token").body(webRtcTokenRequestModel).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public GenerateWebRtcTokenRequest generateWebRtcToken(WebRtcTokenRequestModel webRtcTokenRequestModel) {
        return new GenerateWebRtcTokenRequest(webRtcTokenRequestModel);
    }

    private RequestDefinition getFileDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/webrtc/1/files/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public GetFileRequest getFile(String id) {
        return new GetFileRequest(id);
    }

    private RequestDefinition getFilesDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/webrtc/1/files").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetFilesRequest getFiles() {
        return new GetFilesRequest();
    }

    private RequestDefinition getPushConfigurationDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/webrtc/1/webrtc-push-config/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public GetPushConfigurationRequest getPushConfiguration(String id) {
        return new GetPushConfigurationRequest(id);
    }

    private RequestDefinition getPushConfigurationsDefinition(Integer page, Integer size) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/webrtc/1/webrtc-push-config").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (size != null) {
            builder.addQueryParameter(new Parameter("size", size));
        }
        return builder.build();
    }

    public GetPushConfigurationsRequest getPushConfigurations(Integer page, Integer size) {
        return new GetPushConfigurationsRequest(page, size);
    }

    private RequestDefinition savePushConfigurationDefinition(WebRtcPushConfigurationRequest webRtcPushConfigurationRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/webrtc/1/webrtc-push-config").body(webRtcPushConfigurationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SavePushConfigurationRequest savePushConfiguration(WebRtcPushConfigurationRequest webRtcPushConfigurationRequest) {
        return new SavePushConfigurationRequest(webRtcPushConfigurationRequest);
    }

    private RequestDefinition updatePushConfigurationDefinition(String id, WebRtcPushConfigurationRequest webRtcPushConfigurationRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/webrtc/1/webrtc-push-config/{id}").body(webRtcPushConfigurationRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public UpdatePushConfigurationRequest updatePushConfiguration(String id, WebRtcPushConfigurationRequest webRtcPushConfigurationRequest) {
        return new UpdatePushConfigurationRequest(id, webRtcPushConfigurationRequest);
    }

    public class UpdatePushConfigurationRequest {
        private final String id;
        private final WebRtcPushConfigurationRequest webRtcPushConfigurationRequest;

        private UpdatePushConfigurationRequest(String id, WebRtcPushConfigurationRequest webRtcPushConfigurationRequest) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
            this.webRtcPushConfigurationRequest = Objects.requireNonNull(webRtcPushConfigurationRequest, "The required parameter 'webRtcPushConfigurationRequest' is missing.");
        }

        public WebRtcPushConfigurationResponse execute() throws ApiException {
            RequestDefinition updatePushConfigurationDefinition = WebRtcApi.this.updatePushConfigurationDefinition(this.id, this.webRtcPushConfigurationRequest);
            return (WebRtcPushConfigurationResponse)WebRtcApi.this.apiClient.execute(updatePushConfigurationDefinition, new TypeReference<WebRtcPushConfigurationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcPushConfigurationResponse> callback) {
            RequestDefinition updatePushConfigurationDefinition = WebRtcApi.this.updatePushConfigurationDefinition(this.id, this.webRtcPushConfigurationRequest);
            return WebRtcApi.this.apiClient.executeAsync(updatePushConfigurationDefinition, new TypeReference<WebRtcPushConfigurationResponse>(){}.getType(), callback);
        }
    }

    public class SavePushConfigurationRequest {
        private final WebRtcPushConfigurationRequest webRtcPushConfigurationRequest;

        private SavePushConfigurationRequest(WebRtcPushConfigurationRequest webRtcPushConfigurationRequest) {
            this.webRtcPushConfigurationRequest = Objects.requireNonNull(webRtcPushConfigurationRequest, "The required parameter 'webRtcPushConfigurationRequest' is missing.");
        }

        public WebRtcPushConfigurationResponse execute() throws ApiException {
            RequestDefinition savePushConfigurationDefinition = WebRtcApi.this.savePushConfigurationDefinition(this.webRtcPushConfigurationRequest);
            return (WebRtcPushConfigurationResponse)WebRtcApi.this.apiClient.execute(savePushConfigurationDefinition, new TypeReference<WebRtcPushConfigurationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcPushConfigurationResponse> callback) {
            RequestDefinition savePushConfigurationDefinition = WebRtcApi.this.savePushConfigurationDefinition(this.webRtcPushConfigurationRequest);
            return WebRtcApi.this.apiClient.executeAsync(savePushConfigurationDefinition, new TypeReference<WebRtcPushConfigurationResponse>(){}.getType(), callback);
        }
    }

    public class GetPushConfigurationsRequest {
        private final Integer page;
        private final Integer size;

        private GetPushConfigurationsRequest(Integer page, Integer size) {
            this.page = Objects.requireNonNull(page, "The required parameter 'page' is missing.");
            this.size = Objects.requireNonNull(size, "The required parameter 'size' is missing.");
        }

        public WebRtcPushConfigurationPageResponse execute() throws ApiException {
            RequestDefinition getPushConfigurationsDefinition = WebRtcApi.this.getPushConfigurationsDefinition(this.page, this.size);
            return (WebRtcPushConfigurationPageResponse)WebRtcApi.this.apiClient.execute(getPushConfigurationsDefinition, new TypeReference<WebRtcPushConfigurationPageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcPushConfigurationPageResponse> callback) {
            RequestDefinition getPushConfigurationsDefinition = WebRtcApi.this.getPushConfigurationsDefinition(this.page, this.size);
            return WebRtcApi.this.apiClient.executeAsync(getPushConfigurationsDefinition, new TypeReference<WebRtcPushConfigurationPageResponse>(){}.getType(), callback);
        }
    }

    public class GetPushConfigurationRequest {
        private final String id;

        private GetPushConfigurationRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcPushConfigurationResponse execute() throws ApiException {
            RequestDefinition getPushConfigurationDefinition = WebRtcApi.this.getPushConfigurationDefinition(this.id);
            return (WebRtcPushConfigurationResponse)WebRtcApi.this.apiClient.execute(getPushConfigurationDefinition, new TypeReference<WebRtcPushConfigurationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcPushConfigurationResponse> callback) {
            RequestDefinition getPushConfigurationDefinition = WebRtcApi.this.getPushConfigurationDefinition(this.id);
            return WebRtcApi.this.apiClient.executeAsync(getPushConfigurationDefinition, new TypeReference<WebRtcPushConfigurationResponse>(){}.getType(), callback);
        }
    }

    public class GetFilesRequest {
        private Integer page;
        private Integer size;

        private GetFilesRequest() {
        }

        public GetFilesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public GetFilesRequest size(Integer size) {
            this.size = size;
            return this;
        }

        public WebRtcFilePageResponse execute() throws ApiException {
            RequestDefinition getFilesDefinition = WebRtcApi.this.getFilesDefinition(this.page, this.size);
            return (WebRtcFilePageResponse)WebRtcApi.this.apiClient.execute(getFilesDefinition, new TypeReference<WebRtcFilePageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcFilePageResponse> callback) {
            RequestDefinition getFilesDefinition = WebRtcApi.this.getFilesDefinition(this.page, this.size);
            return WebRtcApi.this.apiClient.executeAsync(getFilesDefinition, new TypeReference<WebRtcFilePageResponse>(){}.getType(), callback);
        }
    }

    public class GetFileRequest {
        private final String id;

        private GetFileRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcFileResponse execute() throws ApiException {
            RequestDefinition getFileDefinition = WebRtcApi.this.getFileDefinition(this.id);
            return (WebRtcFileResponse)WebRtcApi.this.apiClient.execute(getFileDefinition, new TypeReference<WebRtcFileResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcFileResponse> callback) {
            RequestDefinition getFileDefinition = WebRtcApi.this.getFileDefinition(this.id);
            return WebRtcApi.this.apiClient.executeAsync(getFileDefinition, new TypeReference<WebRtcFileResponse>(){}.getType(), callback);
        }
    }

    public class GenerateWebRtcTokenRequest {
        private final WebRtcTokenRequestModel webRtcTokenRequestModel;

        private GenerateWebRtcTokenRequest(WebRtcTokenRequestModel webRtcTokenRequestModel) {
            this.webRtcTokenRequestModel = Objects.requireNonNull(webRtcTokenRequestModel, "The required parameter 'webRtcTokenRequestModel' is missing.");
        }

        public WebRtcTokenResponseModel execute() throws ApiException {
            RequestDefinition generateWebRtcTokenDefinition = WebRtcApi.this.generateWebRtcTokenDefinition(this.webRtcTokenRequestModel);
            return (WebRtcTokenResponseModel)WebRtcApi.this.apiClient.execute(generateWebRtcTokenDefinition, new TypeReference<WebRtcTokenResponseModel>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcTokenResponseModel> callback) {
            RequestDefinition generateWebRtcTokenDefinition = WebRtcApi.this.generateWebRtcTokenDefinition(this.webRtcTokenRequestModel);
            return WebRtcApi.this.apiClient.executeAsync(generateWebRtcTokenDefinition, new TypeReference<WebRtcTokenResponseModel>(){}.getType(), callback);
        }
    }

    public class DownloadFileRequest {
        private final String id;

        private DownloadFileRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public File execute() throws ApiException {
            RequestDefinition downloadFileDefinition = WebRtcApi.this.downloadFileDefinition(this.id);
            return (File)WebRtcApi.this.apiClient.execute(downloadFileDefinition, new TypeReference<File>(){}.getType());
        }

        public Call executeAsync(ApiCallback<File> callback) {
            RequestDefinition downloadFileDefinition = WebRtcApi.this.downloadFileDefinition(this.id);
            return WebRtcApi.this.apiClient.executeAsync(downloadFileDefinition, new TypeReference<File>(){}.getType(), callback);
        }
    }

    public class DeletePushConfigurationRequest {
        private final String id;

        private DeletePushConfigurationRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deletePushConfigurationDefinition = WebRtcApi.this.deletePushConfigurationDefinition(this.id);
            WebRtcApi.this.apiClient.execute(deletePushConfigurationDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deletePushConfigurationDefinition = WebRtcApi.this.deletePushConfigurationDefinition(this.id);
            return WebRtcApi.this.apiClient.executeAsync(deletePushConfigurationDefinition, callback);
        }
    }

    public class DeleteFileRequest {
        private final String id;

        private DeleteFileRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WebRtcFileResponse execute() throws ApiException {
            RequestDefinition deleteFileDefinition = WebRtcApi.this.deleteFileDefinition(this.id);
            return (WebRtcFileResponse)WebRtcApi.this.apiClient.execute(deleteFileDefinition, new TypeReference<WebRtcFileResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WebRtcFileResponse> callback) {
            RequestDefinition deleteFileDefinition = WebRtcApi.this.deleteFileDefinition(this.id);
            return WebRtcApi.this.apiClient.executeAsync(deleteFileDefinition, new TypeReference<WebRtcFileResponse>(){}.getType(), callback);
        }
    }
}

