/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.infobip.model.CallRoutingUrlSecurityConfig;
import java.util.Objects;

public class CallRoutingHmacUrlSecurityConfig
extends CallRoutingUrlSecurityConfig {
    private String secretKey;
    private AlgorithmEnum algorithm;

    public CallRoutingHmacUrlSecurityConfig() {
        super("HMAC");
    }

    public CallRoutingHmacUrlSecurityConfig secretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @JsonProperty(value="secretKey")
    public String getSecretKey() {
        return this.secretKey;
    }

    @JsonProperty(value="secretKey")
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public CallRoutingHmacUrlSecurityConfig algorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty(value="algorithm")
    public AlgorithmEnum getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallRoutingHmacUrlSecurityConfig callRoutingHmacUrlSecurityConfig = (CallRoutingHmacUrlSecurityConfig)o;
        return Objects.equals(this.secretKey, callRoutingHmacUrlSecurityConfig.secretKey) && Objects.equals((Object)this.algorithm, (Object)callRoutingHmacUrlSecurityConfig.algorithm) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.secretKey, this.algorithm, super.hashCode()});
    }

    @Override
    public String toString() {
        String newLine = System.lineSeparator();
        return "class CallRoutingHmacUrlSecurityConfig {" + newLine + "    " + this.toIndentedString(super.toString()) + newLine + "    secretKey: " + this.toIndentedString(this.secretKey) + newLine + "    algorithm: " + this.toIndentedString((Object)this.algorithm) + newLine + "}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        String lineSeparator = System.lineSeparator();
        String lineSeparatorFollowedByIndentation = lineSeparator + "    ";
        return o.toString().replace(lineSeparator, lineSeparatorFollowedByIndentation);
    }

    public static enum AlgorithmEnum {
        MD5("HMAC_MD5"),
        SHA_1("HMAC_SHA_1"),
        SHA_224("HMAC_SHA_224"),
        SHA_256("HMAC_SHA_256"),
        SHA_384("HMAC_SHA_384"),
        SHA_512("HMAC_SHA_512");

        private String value;

        private AlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AlgorithmEnum fromValue(String value) {
            for (AlgorithmEnum enumElement : AlgorithmEnum.values()) {
                if (!enumElement.value.equals(value)) continue;
                return enumElement;
            }
            throw new IllegalArgumentException("Unexpected enum value '" + value + "'.");
        }
    }
}

