/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.MmsAdvancedRequest;
import com.infobip.model.MmsGeneralStatus;
import com.infobip.model.MmsInboundReportResponse;
import com.infobip.model.MmsLogsResponse;
import com.infobip.model.MmsReportResponse;
import com.infobip.model.MmsSendResult;
import com.infobip.model.MmsUploadBinaryResult;
import java.io.File;
import java.util.Objects;
import okhttp3.Call;

public class MmsApi {
    private final ApiClient apiClient;

    public MmsApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition getInboundMmsMessagesDefinition(Integer limit, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/mms/1/inbox/reports").requiresAuthentication(true).accept("application/json");
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public GetInboundMmsMessagesRequest getInboundMmsMessages() {
        return new GetInboundMmsMessagesRequest();
    }

    private RequestDefinition getOutboundMmsMessageDeliveryReportsDefinition(String bulkId, String messageId, Integer limit, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/mms/1/reports").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public GetOutboundMmsMessageDeliveryReportsRequest getOutboundMmsMessageDeliveryReports() {
        return new GetOutboundMmsMessageDeliveryReportsRequest();
    }

    private RequestDefinition getOutboundMmsMessageLogsDefinition(String from, String to, String bulkId, String messageId, MmsGeneralStatus generalStatus, String sentSince, String sentUntil, Double limit, String mcc, String mnc, String applicationId, String entityId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/mms/1/logs").requiresAuthentication(true).accept("application/json");
        if (from != null) {
            builder.addQueryParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addQueryParameter(new Parameter("to", to));
        }
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (generalStatus != null) {
            builder.addQueryParameter(new Parameter("generalStatus", (Object)generalStatus));
        }
        if (sentSince != null) {
            builder.addQueryParameter(new Parameter("sentSince", sentSince));
        }
        if (sentUntil != null) {
            builder.addQueryParameter(new Parameter("sentUntil", sentUntil));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (mcc != null) {
            builder.addQueryParameter(new Parameter("mcc", mcc));
        }
        if (mnc != null) {
            builder.addQueryParameter(new Parameter("mnc", mnc));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        return builder.build();
    }

    public GetOutboundMmsMessageLogsRequest getOutboundMmsMessageLogs() {
        return new GetOutboundMmsMessageLogsRequest();
    }

    private RequestDefinition sendMmsMessageDefinition(MmsAdvancedRequest mmsAdvancedRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/mms/1/advanced").body(mmsAdvancedRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendMmsMessageRequest sendMmsMessage(MmsAdvancedRequest mmsAdvancedRequest) {
        return new SendMmsMessageRequest(mmsAdvancedRequest);
    }

    private RequestDefinition uploadBinaryDefinition(String xContentId, String xMediaType, File body, Long xValidityPeriodMinutes) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/mms/1/content").body(body).requiresAuthentication(true).accept("application/json").contentType("application/octet-stream");
        if (xContentId != null) {
            builder.addHeaderParameter(new Parameter("X-Content-Id", xContentId));
        }
        if (xMediaType != null) {
            builder.addHeaderParameter(new Parameter("X-Media-Type", xMediaType));
        }
        if (xValidityPeriodMinutes != null) {
            builder.addHeaderParameter(new Parameter("X-Validity-Period-Minutes", xValidityPeriodMinutes));
        }
        return builder.build();
    }

    public UploadBinaryRequest uploadBinary(String xContentId, String xMediaType, File body) {
        return new UploadBinaryRequest(xContentId, xMediaType, body);
    }

    public class UploadBinaryRequest {
        private final String xContentId;
        private final String xMediaType;
        private final File body;
        private Long xValidityPeriodMinutes;

        private UploadBinaryRequest(String xContentId, String xMediaType, File body) {
            this.xContentId = Objects.requireNonNull(xContentId, "The required parameter 'xContentId' is missing.");
            this.xMediaType = Objects.requireNonNull(xMediaType, "The required parameter 'xMediaType' is missing.");
            this.body = Objects.requireNonNull(body, "The required parameter 'body' is missing.");
        }

        public UploadBinaryRequest xValidityPeriodMinutes(Long xValidityPeriodMinutes) {
            this.xValidityPeriodMinutes = xValidityPeriodMinutes;
            return this;
        }

        public MmsUploadBinaryResult execute() throws ApiException {
            RequestDefinition uploadBinaryDefinition = MmsApi.this.uploadBinaryDefinition(this.xContentId, this.xMediaType, this.body, this.xValidityPeriodMinutes);
            return (MmsUploadBinaryResult)MmsApi.this.apiClient.execute(uploadBinaryDefinition, new TypeReference<MmsUploadBinaryResult>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsUploadBinaryResult> callback) {
            RequestDefinition uploadBinaryDefinition = MmsApi.this.uploadBinaryDefinition(this.xContentId, this.xMediaType, this.body, this.xValidityPeriodMinutes);
            return MmsApi.this.apiClient.executeAsync(uploadBinaryDefinition, new TypeReference<MmsUploadBinaryResult>(){}.getType(), callback);
        }
    }

    public class SendMmsMessageRequest {
        private final MmsAdvancedRequest mmsAdvancedRequest;

        private SendMmsMessageRequest(MmsAdvancedRequest mmsAdvancedRequest) {
            this.mmsAdvancedRequest = Objects.requireNonNull(mmsAdvancedRequest, "The required parameter 'mmsAdvancedRequest' is missing.");
        }

        public MmsSendResult execute() throws ApiException {
            RequestDefinition sendMmsMessageDefinition = MmsApi.this.sendMmsMessageDefinition(this.mmsAdvancedRequest);
            return (MmsSendResult)MmsApi.this.apiClient.execute(sendMmsMessageDefinition, new TypeReference<MmsSendResult>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsSendResult> callback) {
            RequestDefinition sendMmsMessageDefinition = MmsApi.this.sendMmsMessageDefinition(this.mmsAdvancedRequest);
            return MmsApi.this.apiClient.executeAsync(sendMmsMessageDefinition, new TypeReference<MmsSendResult>(){}.getType(), callback);
        }
    }

    public class GetOutboundMmsMessageLogsRequest {
        private String from;
        private String to;
        private String bulkId;
        private String messageId;
        private MmsGeneralStatus generalStatus;
        private String sentSince;
        private String sentUntil;
        private Double limit;
        private String mcc;
        private String mnc;
        private String applicationId;
        private String entityId;

        private GetOutboundMmsMessageLogsRequest() {
        }

        public GetOutboundMmsMessageLogsRequest from(String from) {
            this.from = from;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest to(String to) {
            this.to = to;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest generalStatus(MmsGeneralStatus generalStatus) {
            this.generalStatus = generalStatus;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest sentSince(String sentSince) {
            this.sentSince = sentSince;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest sentUntil(String sentUntil) {
            this.sentUntil = sentUntil;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest limit(Double limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest mcc(String mcc) {
            this.mcc = mcc;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest mnc(String mnc) {
            this.mnc = mnc;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetOutboundMmsMessageLogsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public MmsLogsResponse execute() throws ApiException {
            RequestDefinition getOutboundMmsMessageLogsDefinition = MmsApi.this.getOutboundMmsMessageLogsDefinition(this.from, this.to, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.mcc, this.mnc, this.applicationId, this.entityId);
            return (MmsLogsResponse)MmsApi.this.apiClient.execute(getOutboundMmsMessageLogsDefinition, new TypeReference<MmsLogsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsLogsResponse> callback) {
            RequestDefinition getOutboundMmsMessageLogsDefinition = MmsApi.this.getOutboundMmsMessageLogsDefinition(this.from, this.to, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.mcc, this.mnc, this.applicationId, this.entityId);
            return MmsApi.this.apiClient.executeAsync(getOutboundMmsMessageLogsDefinition, new TypeReference<MmsLogsResponse>(){}.getType(), callback);
        }
    }

    public class GetOutboundMmsMessageDeliveryReportsRequest {
        private String bulkId;
        private String messageId;
        private Integer limit;
        private String applicationId;
        private String entityId;

        private GetOutboundMmsMessageDeliveryReportsRequest() {
        }

        public GetOutboundMmsMessageDeliveryReportsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetOutboundMmsMessageDeliveryReportsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public MmsReportResponse execute() throws ApiException {
            RequestDefinition getOutboundMmsMessageDeliveryReportsDefinition = MmsApi.this.getOutboundMmsMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.applicationId, this.entityId);
            return (MmsReportResponse)MmsApi.this.apiClient.execute(getOutboundMmsMessageDeliveryReportsDefinition, new TypeReference<MmsReportResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsReportResponse> callback) {
            RequestDefinition getOutboundMmsMessageDeliveryReportsDefinition = MmsApi.this.getOutboundMmsMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.applicationId, this.entityId);
            return MmsApi.this.apiClient.executeAsync(getOutboundMmsMessageDeliveryReportsDefinition, new TypeReference<MmsReportResponse>(){}.getType(), callback);
        }
    }

    public class GetInboundMmsMessagesRequest {
        private Integer limit;
        private String applicationId;
        private String entityId;

        private GetInboundMmsMessagesRequest() {
        }

        public GetInboundMmsMessagesRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetInboundMmsMessagesRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetInboundMmsMessagesRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public MmsInboundReportResponse execute() throws ApiException {
            RequestDefinition getInboundMmsMessagesDefinition = MmsApi.this.getInboundMmsMessagesDefinition(this.limit, this.applicationId, this.entityId);
            return (MmsInboundReportResponse)MmsApi.this.apiClient.execute(getInboundMmsMessagesDefinition, new TypeReference<MmsInboundReportResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MmsInboundReportResponse> callback) {
            RequestDefinition getInboundMmsMessagesDefinition = MmsApi.this.getInboundMmsMessagesDefinition(this.limit, this.applicationId, this.entityId);
            return MmsApi.this.apiClient.executeAsync(getInboundMmsMessagesDefinition, new TypeReference<MmsInboundReportResponse>(){}.getType(), callback);
        }
    }
}

