/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.CallsAdvancedBody;
import com.infobip.model.CallsBulkRequest;
import com.infobip.model.CallsBulkResponse;
import com.infobip.model.CallsBulkStatusResponse;
import com.infobip.model.CallsGetVoicesResponse;
import com.infobip.model.CallsMultiBody;
import com.infobip.model.CallsSingleBody;
import com.infobip.model.CallsUpdateStatusRequest;
import com.infobip.model.CallsVoiceResponse;
import java.util.Objects;
import okhttp3.Call;

public class VoiceApi {
    private final ApiClient apiClient;

    public VoiceApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition getSentBulksDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/tts/3/bulks").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetSentBulksRequest getSentBulks(String bulkId) {
        return new GetSentBulksRequest(bulkId);
    }

    private RequestDefinition getSentBulksStatusDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/tts/3/bulks/status").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetSentBulksStatusRequest getSentBulksStatus(String bulkId) {
        return new GetSentBulksStatusRequest(bulkId);
    }

    private RequestDefinition getVoicesDefinition(String language) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/tts/3/voices/{language}").requiresAuthentication(true).accept("application/json");
        if (language != null) {
            builder.addPathParameter(new Parameter("language", language));
        }
        return builder.build();
    }

    public GetVoicesRequest getVoices(String language) {
        return new GetVoicesRequest(language);
    }

    private RequestDefinition manageSentBulksStatusDefinition(String bulkId, CallsUpdateStatusRequest callsUpdateStatusRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/tts/3/bulks/status").body(callsUpdateStatusRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public ManageSentBulksStatusRequest manageSentBulksStatus(String bulkId, CallsUpdateStatusRequest callsUpdateStatusRequest) {
        return new ManageSentBulksStatusRequest(bulkId, callsUpdateStatusRequest);
    }

    private RequestDefinition rescheduleSentBulkDefinition(String bulkId, CallsBulkRequest callsBulkRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/tts/3/bulks").body(callsBulkRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public RescheduleSentBulkRequest rescheduleSentBulk(String bulkId, CallsBulkRequest callsBulkRequest) {
        return new RescheduleSentBulkRequest(bulkId, callsBulkRequest);
    }

    private RequestDefinition sendAdvancedVoiceTtsDefinition(CallsAdvancedBody callsAdvancedBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/tts/3/advanced").body(callsAdvancedBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendAdvancedVoiceTtsRequest sendAdvancedVoiceTts(CallsAdvancedBody callsAdvancedBody) {
        return new SendAdvancedVoiceTtsRequest(callsAdvancedBody);
    }

    private RequestDefinition sendMultipleVoiceTtsDefinition(CallsMultiBody callsMultiBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/tts/3/multi").body(callsMultiBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendMultipleVoiceTtsRequest sendMultipleVoiceTts(CallsMultiBody callsMultiBody) {
        return new SendMultipleVoiceTtsRequest(callsMultiBody);
    }

    private RequestDefinition sendSingleVoiceTtsDefinition(CallsSingleBody callsSingleBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/tts/3/single").body(callsSingleBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendSingleVoiceTtsRequest sendSingleVoiceTts(CallsSingleBody callsSingleBody) {
        return new SendSingleVoiceTtsRequest(callsSingleBody);
    }

    public class SendSingleVoiceTtsRequest {
        private final CallsSingleBody callsSingleBody;

        private SendSingleVoiceTtsRequest(CallsSingleBody callsSingleBody) {
            this.callsSingleBody = Objects.requireNonNull(callsSingleBody, "The required parameter 'callsSingleBody' is missing.");
        }

        public CallsVoiceResponse execute() throws ApiException {
            RequestDefinition sendSingleVoiceTtsDefinition = VoiceApi.this.sendSingleVoiceTtsDefinition(this.callsSingleBody);
            return (CallsVoiceResponse)VoiceApi.this.apiClient.execute(sendSingleVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsVoiceResponse> callback) {
            RequestDefinition sendSingleVoiceTtsDefinition = VoiceApi.this.sendSingleVoiceTtsDefinition(this.callsSingleBody);
            return VoiceApi.this.apiClient.executeAsync(sendSingleVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType(), callback);
        }
    }

    public class SendMultipleVoiceTtsRequest {
        private final CallsMultiBody callsMultiBody;

        private SendMultipleVoiceTtsRequest(CallsMultiBody callsMultiBody) {
            this.callsMultiBody = Objects.requireNonNull(callsMultiBody, "The required parameter 'callsMultiBody' is missing.");
        }

        public CallsVoiceResponse execute() throws ApiException {
            RequestDefinition sendMultipleVoiceTtsDefinition = VoiceApi.this.sendMultipleVoiceTtsDefinition(this.callsMultiBody);
            return (CallsVoiceResponse)VoiceApi.this.apiClient.execute(sendMultipleVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsVoiceResponse> callback) {
            RequestDefinition sendMultipleVoiceTtsDefinition = VoiceApi.this.sendMultipleVoiceTtsDefinition(this.callsMultiBody);
            return VoiceApi.this.apiClient.executeAsync(sendMultipleVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType(), callback);
        }
    }

    public class SendAdvancedVoiceTtsRequest {
        private final CallsAdvancedBody callsAdvancedBody;

        private SendAdvancedVoiceTtsRequest(CallsAdvancedBody callsAdvancedBody) {
            this.callsAdvancedBody = Objects.requireNonNull(callsAdvancedBody, "The required parameter 'callsAdvancedBody' is missing.");
        }

        public CallsVoiceResponse execute() throws ApiException {
            RequestDefinition sendAdvancedVoiceTtsDefinition = VoiceApi.this.sendAdvancedVoiceTtsDefinition(this.callsAdvancedBody);
            return (CallsVoiceResponse)VoiceApi.this.apiClient.execute(sendAdvancedVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsVoiceResponse> callback) {
            RequestDefinition sendAdvancedVoiceTtsDefinition = VoiceApi.this.sendAdvancedVoiceTtsDefinition(this.callsAdvancedBody);
            return VoiceApi.this.apiClient.executeAsync(sendAdvancedVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType(), callback);
        }
    }

    public class RescheduleSentBulkRequest {
        private final String bulkId;
        private final CallsBulkRequest callsBulkRequest;

        private RescheduleSentBulkRequest(String bulkId, CallsBulkRequest callsBulkRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.callsBulkRequest = Objects.requireNonNull(callsBulkRequest, "The required parameter 'callsBulkRequest' is missing.");
        }

        public CallsBulkResponse execute() throws ApiException {
            RequestDefinition rescheduleSentBulkDefinition = VoiceApi.this.rescheduleSentBulkDefinition(this.bulkId, this.callsBulkRequest);
            return (CallsBulkResponse)VoiceApi.this.apiClient.execute(rescheduleSentBulkDefinition, new TypeReference<CallsBulkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsBulkResponse> callback) {
            RequestDefinition rescheduleSentBulkDefinition = VoiceApi.this.rescheduleSentBulkDefinition(this.bulkId, this.callsBulkRequest);
            return VoiceApi.this.apiClient.executeAsync(rescheduleSentBulkDefinition, new TypeReference<CallsBulkResponse>(){}.getType(), callback);
        }
    }

    public class ManageSentBulksStatusRequest {
        private final String bulkId;
        private final CallsUpdateStatusRequest callsUpdateStatusRequest;

        private ManageSentBulksStatusRequest(String bulkId, CallsUpdateStatusRequest callsUpdateStatusRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.callsUpdateStatusRequest = Objects.requireNonNull(callsUpdateStatusRequest, "The required parameter 'callsUpdateStatusRequest' is missing.");
        }

        public CallsBulkStatusResponse execute() throws ApiException {
            RequestDefinition manageSentBulksStatusDefinition = VoiceApi.this.manageSentBulksStatusDefinition(this.bulkId, this.callsUpdateStatusRequest);
            return (CallsBulkStatusResponse)VoiceApi.this.apiClient.execute(manageSentBulksStatusDefinition, new TypeReference<CallsBulkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsBulkStatusResponse> callback) {
            RequestDefinition manageSentBulksStatusDefinition = VoiceApi.this.manageSentBulksStatusDefinition(this.bulkId, this.callsUpdateStatusRequest);
            return VoiceApi.this.apiClient.executeAsync(manageSentBulksStatusDefinition, new TypeReference<CallsBulkStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetVoicesRequest {
        private final String language;

        private GetVoicesRequest(String language) {
            this.language = Objects.requireNonNull(language, "The required parameter 'language' is missing.");
        }

        public CallsGetVoicesResponse execute() throws ApiException {
            RequestDefinition getVoicesDefinition = VoiceApi.this.getVoicesDefinition(this.language);
            return (CallsGetVoicesResponse)VoiceApi.this.apiClient.execute(getVoicesDefinition, new TypeReference<CallsGetVoicesResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsGetVoicesResponse> callback) {
            RequestDefinition getVoicesDefinition = VoiceApi.this.getVoicesDefinition(this.language);
            return VoiceApi.this.apiClient.executeAsync(getVoicesDefinition, new TypeReference<CallsGetVoicesResponse>(){}.getType(), callback);
        }
    }

    public class GetSentBulksStatusRequest {
        private final String bulkId;

        private GetSentBulksStatusRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public CallsBulkStatusResponse execute() throws ApiException {
            RequestDefinition getSentBulksStatusDefinition = VoiceApi.this.getSentBulksStatusDefinition(this.bulkId);
            return (CallsBulkStatusResponse)VoiceApi.this.apiClient.execute(getSentBulksStatusDefinition, new TypeReference<CallsBulkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsBulkStatusResponse> callback) {
            RequestDefinition getSentBulksStatusDefinition = VoiceApi.this.getSentBulksStatusDefinition(this.bulkId);
            return VoiceApi.this.apiClient.executeAsync(getSentBulksStatusDefinition, new TypeReference<CallsBulkStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetSentBulksRequest {
        private final String bulkId;

        private GetSentBulksRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public CallsBulkResponse execute() throws ApiException {
            RequestDefinition getSentBulksDefinition = VoiceApi.this.getSentBulksDefinition(this.bulkId);
            return (CallsBulkResponse)VoiceApi.this.apiClient.execute(getSentBulksDefinition, new TypeReference<CallsBulkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsBulkResponse> callback) {
            RequestDefinition getSentBulksDefinition = VoiceApi.this.getSentBulksDefinition(this.bulkId);
            return VoiceApi.this.apiClient.executeAsync(getSentBulksDefinition, new TypeReference<CallsBulkResponse>(){}.getType(), callback);
        }
    }
}

