/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.infobip.JSONException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class JSON {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final ObjectMapper objectMapper = this.configureObjectMapper();

    public String serialize(Object target) {
        try {
            return this.objectMapper.writeValueAsString(target);
        }
        catch (Exception e) {
            throw JSONException.becauseSerializationFailed(e);
        }
    }

    public <T> T deserialize(String target, Type targetType) {
        try {
            return (T)this.objectMapper.readValue(target, JSON.asTypeReference(targetType));
        }
        catch (Exception e) {
            throw JSONException.becauseDeserializationFailed(e);
        }
    }

    public <T> T deserialize(InputStream target, Type targetType) {
        try {
            return (T)this.objectMapper.readValue(target, JSON.asTypeReference(targetType));
        }
        catch (Exception e) {
            throw JSONException.becauseDeserializationFailed(e);
        }
    }

    public DateTimeFormatter dateTimeFormatter() {
        return DATE_TIME_FORMATTER;
    }

    protected ObjectMapper configureObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        objectMapper.registerModule((Module)this.configureJavaTimeModule());
        return objectMapper;
    }

    protected JavaTimeModule configureJavaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(OffsetDateTime.class, (JsonSerializer)OffsetDateTimeSerializer.INSTANCE);
        return javaTimeModule;
    }

    private static <T> TypeReference<T> asTypeReference(final Type targetType) {
        return new TypeReference<T>(){

            public Type getType() {
                return targetType;
            }
        };
    }

    private static class OffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        private static final OffsetDateTimeSerializer INSTANCE = new OffsetDateTimeSerializer();

        private OffsetDateTimeSerializer() {
        }

        public void serialize(OffsetDateTime value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(DATE_TIME_FORMATTER.format(value));
        }
    }
}

