/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infobip.model.CallDirection;
import com.infobip.model.CallEndpoint;
import com.infobip.model.CallState;
import com.infobip.model.CallsMachineDetectionProperties;
import com.infobip.model.CallsMediaProperties;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Call {
    private String id;
    private CallEndpoint endpoint;
    private String from;
    private String to;
    private CallDirection direction;
    private CallState state;
    private CallsMediaProperties media;
    private OffsetDateTime startTime;
    private OffsetDateTime answerTime;
    private OffsetDateTime endTime;
    private String parentCallId;
    private CallsMachineDetectionProperties machineDetection;
    private Integer ringDuration;
    private String callsConfigurationId;
    private String applicationId;
    private String conferenceId;
    private Map<String, String> customData = null;
    private String dialogId;

    public Call id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Call endpoint(CallEndpoint endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @JsonProperty(value="endpoint")
    public CallEndpoint getEndpoint() {
        return this.endpoint;
    }

    @JsonProperty(value="endpoint")
    public void setEndpoint(CallEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Call from(String from) {
        this.from = from;
        return this;
    }

    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    public void setFrom(String from) {
        this.from = from;
    }

    public Call to(String to) {
        this.to = to;
        return this;
    }

    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    @JsonProperty(value="to")
    public void setTo(String to) {
        this.to = to;
    }

    public Call direction(CallDirection direction) {
        this.direction = direction;
        return this;
    }

    @JsonProperty(value="direction")
    public CallDirection getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    public void setDirection(CallDirection direction) {
        this.direction = direction;
    }

    public Call state(CallState state) {
        this.state = state;
        return this;
    }

    @JsonProperty(value="state")
    public CallState getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(CallState state) {
        this.state = state;
    }

    public Call media(CallsMediaProperties media) {
        this.media = media;
        return this;
    }

    @JsonProperty(value="media")
    public CallsMediaProperties getMedia() {
        return this.media;
    }

    @JsonProperty(value="media")
    public void setMedia(CallsMediaProperties media) {
        this.media = media;
    }

    public Call startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty(value="startTime")
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public Call answerTime(OffsetDateTime answerTime) {
        this.answerTime = answerTime;
        return this;
    }

    @JsonProperty(value="answerTime")
    public OffsetDateTime getAnswerTime() {
        return this.answerTime;
    }

    @JsonProperty(value="answerTime")
    public void setAnswerTime(OffsetDateTime answerTime) {
        this.answerTime = answerTime;
    }

    public Call endTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty(value="endTime")
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    public void setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
    }

    public Call parentCallId(String parentCallId) {
        this.parentCallId = parentCallId;
        return this;
    }

    @JsonProperty(value="parentCallId")
    public String getParentCallId() {
        return this.parentCallId;
    }

    @JsonProperty(value="parentCallId")
    public void setParentCallId(String parentCallId) {
        this.parentCallId = parentCallId;
    }

    public Call machineDetection(CallsMachineDetectionProperties machineDetection) {
        this.machineDetection = machineDetection;
        return this;
    }

    @JsonProperty(value="machineDetection")
    public CallsMachineDetectionProperties getMachineDetection() {
        return this.machineDetection;
    }

    @JsonProperty(value="machineDetection")
    public void setMachineDetection(CallsMachineDetectionProperties machineDetection) {
        this.machineDetection = machineDetection;
    }

    public Call ringDuration(Integer ringDuration) {
        this.ringDuration = ringDuration;
        return this;
    }

    @JsonProperty(value="ringDuration")
    public Integer getRingDuration() {
        return this.ringDuration;
    }

    @JsonProperty(value="ringDuration")
    public void setRingDuration(Integer ringDuration) {
        this.ringDuration = ringDuration;
    }

    public Call callsConfigurationId(String callsConfigurationId) {
        this.callsConfigurationId = callsConfigurationId;
        return this;
    }

    @JsonProperty(value="callsConfigurationId")
    public String getCallsConfigurationId() {
        return this.callsConfigurationId;
    }

    @JsonProperty(value="callsConfigurationId")
    public void setCallsConfigurationId(String callsConfigurationId) {
        this.callsConfigurationId = callsConfigurationId;
    }

    public Call applicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    @JsonProperty(value="applicationId")
    public String getApplicationId() {
        return this.applicationId;
    }

    @JsonProperty(value="applicationId")
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public Call conferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
        return this;
    }

    @JsonProperty(value="conferenceId")
    public String getConferenceId() {
        return this.conferenceId;
    }

    @JsonProperty(value="conferenceId")
    public void setConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
    }

    public Call customData(Map<String, String> customData) {
        this.customData = customData;
        return this;
    }

    public Call putCustomDataItem(String key, String customDataItem) {
        if (this.customData == null) {
            this.customData = new HashMap<String, String>();
        }
        this.customData.put(key, customDataItem);
        return this;
    }

    @JsonProperty(value="customData")
    public Map<String, String> getCustomData() {
        return this.customData;
    }

    @JsonProperty(value="customData")
    public void setCustomData(Map<String, String> customData) {
        this.customData = customData;
    }

    public Call dialogId(String dialogId) {
        this.dialogId = dialogId;
        return this;
    }

    @JsonProperty(value="dialogId")
    public String getDialogId() {
        return this.dialogId;
    }

    @JsonProperty(value="dialogId")
    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Call call = (Call)o;
        return Objects.equals(this.id, call.id) && Objects.equals(this.endpoint, call.endpoint) && Objects.equals(this.from, call.from) && Objects.equals(this.to, call.to) && Objects.equals((Object)this.direction, (Object)call.direction) && Objects.equals((Object)this.state, (Object)call.state) && Objects.equals(this.media, call.media) && Objects.equals(this.startTime, call.startTime) && Objects.equals(this.answerTime, call.answerTime) && Objects.equals(this.endTime, call.endTime) && Objects.equals(this.parentCallId, call.parentCallId) && Objects.equals(this.machineDetection, call.machineDetection) && Objects.equals(this.ringDuration, call.ringDuration) && Objects.equals(this.callsConfigurationId, call.callsConfigurationId) && Objects.equals(this.applicationId, call.applicationId) && Objects.equals(this.conferenceId, call.conferenceId) && Objects.equals(this.customData, call.customData) && Objects.equals(this.dialogId, call.dialogId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.endpoint, this.from, this.to, this.direction, this.state, this.media, this.startTime, this.answerTime, this.endTime, this.parentCallId, this.machineDetection, this.ringDuration, this.callsConfigurationId, this.applicationId, this.conferenceId, this.customData, this.dialogId});
    }

    public String toString() {
        String newLine = System.lineSeparator();
        return "class Call {" + newLine + "    id: " + this.toIndentedString(this.id) + newLine + "    endpoint: " + this.toIndentedString(this.endpoint) + newLine + "    from: " + this.toIndentedString(this.from) + newLine + "    to: " + this.toIndentedString(this.to) + newLine + "    direction: " + this.toIndentedString((Object)this.direction) + newLine + "    state: " + this.toIndentedString((Object)this.state) + newLine + "    media: " + this.toIndentedString(this.media) + newLine + "    startTime: " + this.toIndentedString(this.startTime) + newLine + "    answerTime: " + this.toIndentedString(this.answerTime) + newLine + "    endTime: " + this.toIndentedString(this.endTime) + newLine + "    parentCallId: " + this.toIndentedString(this.parentCallId) + newLine + "    machineDetection: " + this.toIndentedString(this.machineDetection) + newLine + "    ringDuration: " + this.toIndentedString(this.ringDuration) + newLine + "    callsConfigurationId: " + this.toIndentedString(this.callsConfigurationId) + newLine + "    applicationId: " + this.toIndentedString(this.applicationId) + newLine + "    conferenceId: " + this.toIndentedString(this.conferenceId) + newLine + "    customData: " + this.toIndentedString(this.customData) + newLine + "    dialogId: " + this.toIndentedString(this.dialogId) + newLine + "}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        String lineSeparator = System.lineSeparator();
        String lineSeparatorFollowedByIndentation = lineSeparator + "    ";
        return o.toString().replace(lineSeparator, lineSeparatorFollowedByIndentation);
    }
}

