/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.jackson;

import com.infobip.jackson.JsonTypePropertyName;
import com.infobip.jackson.JsonTypePropertyValue;
import com.infobip.jackson.JsonTypeResolveWith;
import com.infobip.jackson.JsonTypeResolver;
import com.infobip.jackson.PresentPropertyJsonHierarchy;
import com.infobip.jackson.PresentPropertyJsonTypeResolver;
import com.infobip.jackson.SealedJsonHierarchiesTypeResolver;
import com.infobip.jackson.SimpleJsonHierarchy;
import com.infobip.jackson.SimpleJsonTypeResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class JsonTypeResolverFactory {
    private final Set<Class<?>> preferredInterfaces = Set.of(SimpleJsonHierarchy.class, PresentPropertyJsonHierarchy.class);
    private final Set<Class<?>> ignoredClasses = Set.of(SimpleJsonHierarchy.class, PresentPropertyJsonHierarchy.class);

    public Optional<JsonTypeResolver> create(Class<?> type) {
        if (Objects.isNull(type)) {
            return Optional.empty();
        }
        if (this.ignoredClasses.contains(type)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.extractAnnotation(type, JsonTypeResolveWith.class)).map(annotation -> this.createJsonTypeResolver(type, annotation.value()));
    }

    private JsonTypeResolver createJsonTypeResolver(Class<?> targetType, Class<? extends JsonTypeResolver> type) {
        if (type.equals(SimpleJsonTypeResolver.class)) {
            return this.createSimpleTypeJsonResolver(targetType);
        }
        if (type.equals(PresentPropertyJsonTypeResolver.class)) {
            return this.createPresentPropertyJsonTypeResolver(targetType);
        }
        if (this.isSubtypeOf(type, PresentPropertyJsonTypeResolver.class)) {
            try {
                return this.createSubtypeOfPresentPropertyJsonTypeResolver(type, targetType);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to create PresentPropertyJsonTypeResolver for  " + type, e);
            }
        }
        if (type.equals(SealedJsonHierarchiesTypeResolver.class)) {
            return SealedJsonHierarchiesTypeResolver.of(targetType, this::create);
        }
        try {
            return (JsonTypeResolver)this.getConstructor(type, new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to resolve default constructor for " + type, e);
        }
    }

    private <E extends Enum<E>> SimpleJsonTypeResolver<E> createSimpleTypeJsonResolver(Class<?> type) {
        Class enumType = (Class)this.resolveFirstGenericTypeArgument(type, SimpleJsonHierarchy.class);
        String propertyName = Optional.ofNullable(this.extractAnnotation(type, JsonTypePropertyName.class)).map(JsonTypePropertyName::value).orElse("type");
        boolean upperCase = Optional.ofNullable(this.extractAnnotation(type, JsonTypePropertyValue.class)).map(JsonTypePropertyValue::inUpperCase).orElse(true);
        return new SimpleJsonTypeResolver(enumType, propertyName, upperCase);
    }

    private <E extends Enum<E>> PresentPropertyJsonTypeResolver<E> createPresentPropertyJsonTypeResolver(Class<?> type) {
        Class enumType = (Class)this.resolveFirstGenericTypeArgument(type, PresentPropertyJsonHierarchy.class);
        return new PresentPropertyJsonTypeResolver(enumType);
    }

    private <E extends Enum<E>> PresentPropertyJsonTypeResolver<E> createSubtypeOfPresentPropertyJsonTypeResolver(Class<?> resolverType, Class<?> targetType) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        Class enumType = (Class)this.resolveFirstGenericTypeArgument(targetType, PresentPropertyJsonHierarchy.class);
        for (Constructor<?> cctor : resolverType.getConstructors()) {
            if (cctor.getParameterCount() == 0) {
                return (PresentPropertyJsonTypeResolver)this.getConstructor(resolverType, new Class[0]).newInstance(new Object[0]);
            }
            if (cctor.getParameterCount() != 1 || !cctor.getParameterTypes()[0].equals(Class.class)) continue;
            return (PresentPropertyJsonTypeResolver)this.getConstructor(resolverType, Class.class).newInstance(enumType);
        }
        throw new IllegalArgumentException("Failed to resolve default constructor for " + resolverType);
    }

    private Constructor<?> getConstructor(Class<?> resolved, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<?> constructor = resolved.getDeclaredConstructor(parameterTypes);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor;
    }

    private <A extends Annotation> A extractAnnotation(Class<?> type, Class<A> annotationType) {
        if (Objects.isNull(type)) {
            return null;
        }
        A currentJsonTypeResolveWith = type.getAnnotation(annotationType);
        if (Objects.nonNull(currentJsonTypeResolveWith)) {
            return currentJsonTypeResolveWith;
        }
        Class<?>[] interfaces = type.getInterfaces();
        for (Class<?> preferredInterface : this.preferredInterfaces) {
            for (Class<?> anInterface : interfaces) {
                if (!preferredInterface.equals(anInterface)) continue;
                return anInterface.getAnnotation(annotationType);
            }
        }
        for (Class<?> anInterface : interfaces) {
            A annotationJsonTypeResolveWith = this.extractAnnotation(anInterface, annotationType);
            if (!Objects.nonNull(annotationJsonTypeResolveWith)) continue;
            return annotationJsonTypeResolveWith;
        }
        return this.extractAnnotation(type.getSuperclass(), annotationType);
    }

    private <T> T resolveFirstGenericTypeArgument(Class<?> type, Class<?> interfaceType) {
        List<Type> genericInterfaces = this.getAllInterfaces(type);
        for (Type genericInterface : genericInterfaces) {
            ParameterizedType parameterizedInterface;
            if (!(genericInterface instanceof ParameterizedType) || !interfaceType.equals((parameterizedInterface = (ParameterizedType)genericInterface).getRawType())) continue;
            Type typeArgument = parameterizedInterface.getActualTypeArguments()[0];
            return (T)typeArgument;
        }
        throw new IllegalArgumentException("Failed to resolve type argument " + type + " " + interfaceType + " with index0");
    }

    private List<Type> getAllInterfaces(Class<?> type) {
        ArrayList<Type> allInterfaces = new ArrayList<Type>();
        for (Type anInterface : type.getGenericInterfaces()) {
            allInterfaces.add(anInterface);
            if (!(anInterface instanceof Class)) continue;
            allInterfaces.addAll(this.getAllInterfaces((Class)anInterface));
        }
        Optional.ofNullable(type.getGenericSuperclass()).map(superClass -> superClass instanceof ParameterizedType ? ((ParameterizedType)superClass).getRawType() : superClass).ifPresent(superClass -> allInterfaces.addAll(this.getAllInterfaces((Class)superClass)));
        return allInterfaces;
    }

    private boolean isSubtypeOf(Class<?> type, Class<?> parentType) {
        return type.getSuperclass() != null && (type.getSuperclass().equals(parentType) || this.isSubtypeOf(type.getSuperclass(), parentType));
    }
}

