/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.jackson.dynamic;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.infobip.jackson.TypeProvider;
import com.infobip.jackson.dynamic.JsonValueToJavaTypeJacksonMapping;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DynamicHierarchyDeserializer<T>
extends JsonDeserializer<T> {
    private final Class<T> hierarchyRootType;
    private final Map<String, Class<? extends T>> jsonValueToJavaType;
    private final String jsonValuePropertyName;

    public DynamicHierarchyDeserializer(Class<T> hierarchyRootType, List<JsonValueToJavaTypeJacksonMapping<T>> mappings) {
        this(hierarchyRootType, mappings, "type");
    }

    public DynamicHierarchyDeserializer(Class<T> hierarchyRootType, List<JsonValueToJavaTypeJacksonMapping<T>> mappings, String jsonValuePropertyName) {
        this.hierarchyRootType = hierarchyRootType;
        this.jsonValueToJavaType = mappings.stream().collect(Collectors.toMap(JsonValueToJavaTypeJacksonMapping::getJsonValue, JsonValueToJavaTypeJacksonMapping::getJavaType));
        this.jsonValuePropertyName = jsonValuePropertyName;
    }

    public static <R, V extends Enum<V>> DynamicHierarchyDeserializer<R> from(Class<V> enumTypeProvider) {
        return new DynamicHierarchyDeserializer<R>(DynamicHierarchyDeserializer.getHierarchyRootType(enumTypeProvider), JsonValueToJavaTypeJacksonMapping.from(enumTypeProvider));
    }

    public static <R, V extends Enum<V>> DynamicHierarchyDeserializer<R> from(Class<V> enumTypeProvider, String jsonValuePropertyName) {
        return new DynamicHierarchyDeserializer<R>(DynamicHierarchyDeserializer.getHierarchyRootType(enumTypeProvider), JsonValueToJavaTypeJacksonMapping.from(enumTypeProvider), jsonValuePropertyName);
    }

    private static <R, V extends Enum<V>> Class<R> getHierarchyRootType(Class<V> enumTypeProvider) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = enumTypeProvider.getGenericInterfaces()) {
            ParameterizedType parameterizedInterface;
            if (!(genericInterface instanceof ParameterizedType) || !TypeProvider.class.equals((Object)(parameterizedInterface = (ParameterizedType)genericInterface).getRawType())) continue;
            Class typeArgument = (Class)parameterizedInterface.getActualTypeArguments()[0];
            return typeArgument;
        }
        throw new IllegalArgumentException("Failed to resolve type argument " + enumTypeProvider + " " + TypeProvider.class + " with index0");
    }

    public final T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = p.getCodec();
        JsonNode tree = (JsonNode)codec.readTree(p);
        String jsonValue = tree.get(this.jsonValuePropertyName).textValue();
        Class<? extends T> javaType = this.jsonValueToJavaType.get(jsonValue);
        if (Objects.isNull(javaType)) {
            throw new IllegalArgumentException("No java type mapping specified for json value: " + jsonValue);
        }
        return (T)((ObjectMapper)codec).convertValue((Object)tree, javaType);
    }

    public Class<T> getHierarchyRootType() {
        return this.hierarchyRootType;
    }

    public Map<String, Class<? extends T>> getJsonValueToJavaType() {
        return this.jsonValueToJavaType;
    }

    public String getJsonValuePropertyName() {
        return this.jsonValuePropertyName;
    }
}

